/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatLongProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenFloatLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        OpenFloatLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatLongHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        OpenFloatLongHashMap map2 = (OpenFloatLongHashMap)map.clone();
        map.clear();
        OpenFloatLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        OpenFloatLongHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatLongHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        OpenFloatLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenFloatLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatLongHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        map.forEachPair(new FloatLongProcedure(){

            public boolean apply(float first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatLongHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenFloatLongHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenFloatLongHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new FloatLongProcedure(){
            int count = 0;

            public boolean apply(float first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        OpenFloatLongHashMapTest.assertEquals((long)22L, (long)map.get(11.0f));
        OpenFloatLongHashMapTest.assertEquals((long)0L, (long)map.get(0.0f));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.adjustOrPutValue(11.0f, 1L, 3L);
        OpenFloatLongHashMapTest.assertEquals((long)25L, (long)map.get(11.0f));
        map.adjustOrPutValue(15.0f, 1L, 3L);
        OpenFloatLongHashMapTest.assertEquals((long)1L, (long)map.get(15.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 22L);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatLongHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatLongProcedure(){

            public boolean apply(float first, long second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatLongHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenFloatLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenFloatLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenFloatLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenFloatLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        OpenFloatLongHashMap map2 = (OpenFloatLongHashMap)map.copy();
        map.clear();
        OpenFloatLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        OpenFloatLongHashMap map2 = (OpenFloatLongHashMap)map.copy();
        OpenFloatLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 22L);
        map.put(12.0f, 23L);
        map.put(13.0f, 24L);
        map.put(14.0f, 25L);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatLongHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatLongHashMap map = new OpenFloatLongHashMap();
        map.put(11.0f, 100L);
        map.put(12.0f, 70L);
        map.put(13.0f, 30L);
        map.put(14.0f, 3L);
        FloatArrayList keys = new FloatArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatLongHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenFloatLongHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenFloatLongHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenFloatLongHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatLongHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenFloatLongHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenFloatLongHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenFloatLongHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        long v;

        Pair(float k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

