/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatIntProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenFloatIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        OpenFloatIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatIntHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        OpenFloatIntHashMap map2 = (OpenFloatIntHashMap)map.clone();
        map.clear();
        OpenFloatIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        OpenFloatIntHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatIntHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        OpenFloatIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenFloatIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatIntHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        map.forEachPair(new FloatIntProcedure(){

            public boolean apply(float first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatIntHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenFloatIntHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenFloatIntHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new FloatIntProcedure(){
            int count = 0;

            public boolean apply(float first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        OpenFloatIntHashMapTest.assertEquals((long)22L, (long)map.get(11.0f));
        OpenFloatIntHashMapTest.assertEquals((long)0L, (long)map.get(0.0f));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.adjustOrPutValue(11.0f, 1, 3);
        OpenFloatIntHashMapTest.assertEquals((long)25L, (long)map.get(11.0f));
        map.adjustOrPutValue(15.0f, 1, 3);
        OpenFloatIntHashMapTest.assertEquals((long)1L, (long)map.get(15.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 22);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatIntHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatIntProcedure(){

            public boolean apply(float first, int second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatIntHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenFloatIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenFloatIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenFloatIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenFloatIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        OpenFloatIntHashMap map2 = (OpenFloatIntHashMap)map.copy();
        map.clear();
        OpenFloatIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        OpenFloatIntHashMap map2 = (OpenFloatIntHashMap)map.copy();
        OpenFloatIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 22);
        map.put(12.0f, 23);
        map.put(13.0f, 24);
        map.put(14.0f, 25);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatIntHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatIntHashMap map = new OpenFloatIntHashMap();
        map.put(11.0f, 100);
        map.put(12.0f, 70);
        map.put(13.0f, 30);
        map.put(14.0f, 3);
        FloatArrayList keys = new FloatArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatIntHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenFloatIntHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenFloatIntHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenFloatIntHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatIntHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenFloatIntHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenFloatIntHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenFloatIntHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        int v;

        Pair(float k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

