/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatDoubleProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenFloatDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        OpenFloatDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        OpenFloatDoubleHashMap map2 = (OpenFloatDoubleHashMap)map.clone();
        map.clear();
        OpenFloatDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        OpenFloatDoubleHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatDoubleHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        OpenFloatDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenFloatDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatDoubleHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        map.forEachPair(new FloatDoubleProcedure(){

            public boolean apply(float first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatDoubleHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new FloatDoubleProcedure(){
            int count = 0;

            public boolean apply(float first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        OpenFloatDoubleHashMapTest.assertEquals((double)22.0, (double)map.get(11.0f), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(0.0f), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.adjustOrPutValue(11.0f, 1.0, 3.0);
        OpenFloatDoubleHashMapTest.assertEquals((double)25.0, (double)map.get(11.0f), (double)1.0E-6);
        map.adjustOrPutValue(15.0f, 1.0, 3.0);
        OpenFloatDoubleHashMapTest.assertEquals((double)1.0, (double)map.get(15.0f), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 22.0);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatDoubleProcedure(){

            public boolean apply(float first, double second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatDoubleHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenFloatDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        OpenFloatDoubleHashMap map2 = (OpenFloatDoubleHashMap)map.copy();
        map.clear();
        OpenFloatDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        OpenFloatDoubleHashMap map2 = (OpenFloatDoubleHashMap)map.copy();
        OpenFloatDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 22.0);
        map.put(12.0f, 23.0);
        map.put(13.0f, 24.0);
        map.put(14.0f, 25.0);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatDoubleHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatDoubleHashMap map = new OpenFloatDoubleHashMap();
        map.put(11.0f, 100.0);
        map.put(12.0f, 70.0);
        map.put(13.0f, 30.0);
        map.put(14.0f, 3.0);
        FloatArrayList keys = new FloatArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatDoubleHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenFloatDoubleHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        double v;

        Pair(float k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

