/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatByteProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenFloatByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        OpenFloatByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatByteHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        OpenFloatByteHashMap map2 = (OpenFloatByteHashMap)map.clone();
        map.clear();
        OpenFloatByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        OpenFloatByteHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatByteHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        OpenFloatByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenFloatByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatByteHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        map.forEachPair(new FloatByteProcedure(){

            public boolean apply(float first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatByteHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenFloatByteHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenFloatByteHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new FloatByteProcedure(){
            int count = 0;

            public boolean apply(float first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        OpenFloatByteHashMapTest.assertEquals((long)22L, (long)map.get(11.0f));
        OpenFloatByteHashMapTest.assertEquals((long)0L, (long)map.get(0.0f));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.adjustOrPutValue(11.0f, (byte)1, (byte)3);
        OpenFloatByteHashMapTest.assertEquals((long)25L, (long)map.get(11.0f));
        map.adjustOrPutValue(15.0f, (byte)1, (byte)3);
        OpenFloatByteHashMapTest.assertEquals((long)1L, (long)map.get(15.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)22);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatByteHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatByteProcedure(){

            public boolean apply(float first, byte second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatByteHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenFloatByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenFloatByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenFloatByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenFloatByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        OpenFloatByteHashMap map2 = (OpenFloatByteHashMap)map.copy();
        map.clear();
        OpenFloatByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        OpenFloatByteHashMap map2 = (OpenFloatByteHashMap)map.copy();
        OpenFloatByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)22);
        map.put(12.0f, (byte)23);
        map.put(13.0f, (byte)24);
        map.put(14.0f, (byte)25);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatByteHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatByteHashMap map = new OpenFloatByteHashMap();
        map.put(11.0f, (byte)100);
        map.put(12.0f, (byte)70);
        map.put(13.0f, (byte)30);
        map.put(14.0f, (byte)3);
        FloatArrayList keys = new FloatArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatByteHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenFloatByteHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenFloatByteHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenFloatByteHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatByteHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenFloatByteHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenFloatByteHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenFloatByteHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        byte v;

        Pair(float k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

