/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleIntProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenDoubleIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        OpenDoubleIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleIntHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        OpenDoubleIntHashMap map2 = (OpenDoubleIntHashMap)map.clone();
        map.clear();
        OpenDoubleIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        OpenDoubleIntHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleIntHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        OpenDoubleIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenDoubleIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleIntHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        map.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleIntHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenDoubleIntHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenDoubleIntHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new DoubleIntProcedure(){
            int count = 0;

            public boolean apply(double first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        OpenDoubleIntHashMapTest.assertEquals((long)22L, (long)map.get(11.0));
        OpenDoubleIntHashMapTest.assertEquals((long)0L, (long)map.get(0.0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.adjustOrPutValue(11.0, 1, 3);
        OpenDoubleIntHashMapTest.assertEquals((long)25L, (long)map.get(11.0));
        map.adjustOrPutValue(15.0, 1, 3);
        OpenDoubleIntHashMapTest.assertEquals((long)1L, (long)map.get(15.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 22);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleIntHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleIntProcedure(){

            public boolean apply(double first, int second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleIntHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenDoubleIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenDoubleIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenDoubleIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenDoubleIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        OpenDoubleIntHashMap map2 = (OpenDoubleIntHashMap)map.copy();
        map.clear();
        OpenDoubleIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        OpenDoubleIntHashMap map2 = (OpenDoubleIntHashMap)map.copy();
        OpenDoubleIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 22);
        map.put(12.0, 23);
        map.put(13.0, 24);
        map.put(14.0, 25);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleIntHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        map.put(11.0, 100);
        map.put(12.0, 70);
        map.put(13.0, 30);
        map.put(14.0, 3);
        DoubleArrayList keys = new DoubleArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleIntHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenDoubleIntHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenDoubleIntHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenDoubleIntHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleIntHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenDoubleIntHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenDoubleIntHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenDoubleIntHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        int v;

        Pair(double k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

