/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharLongProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenCharLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        OpenCharLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharLongHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        OpenCharLongHashMap map2 = (OpenCharLongHashMap)map.clone();
        map.clear();
        OpenCharLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        OpenCharLongHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharLongHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        OpenCharLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenCharLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharLongHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        map.forEachPair(new CharLongProcedure(){

            public boolean apply(char first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenCharLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenCharLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new CharLongProcedure(){
            int count = 0;

            public boolean apply(char first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        OpenCharLongHashMapTest.assertEquals((long)22L, (long)map.get('\u000b'));
        OpenCharLongHashMapTest.assertEquals((long)0L, (long)map.get('\u0000'));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.adjustOrPutValue('\u000b', 1L, 3L);
        OpenCharLongHashMapTest.assertEquals((long)25L, (long)map.get('\u000b'));
        map.adjustOrPutValue('\u000f', 1L, 3L);
        OpenCharLongHashMapTest.assertEquals((long)1L, (long)map.get('\u000f'));
    }

    @Test
    public void testKeys() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 22L);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        map.pairsMatching(new CharLongProcedure(){

            public boolean apply(char first, long second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharLongHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharLongHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenCharLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenCharLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenCharLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenCharLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        OpenCharLongHashMap map2 = (OpenCharLongHashMap)map.copy();
        map.clear();
        OpenCharLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        OpenCharLongHashMap map2 = (OpenCharLongHashMap)map.copy();
        OpenCharLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 22L);
        map.put('\f', 23L);
        map.put('\r', 24L);
        map.put('\u000e', 25L);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharLongHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharLongHashMap map = new OpenCharLongHashMap();
        map.put('\u000b', 100L);
        map.put('\f', 70L);
        map.put('\r', 30L);
        map.put('\u000e', 3L);
        CharArrayList keys = new CharArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenCharLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenCharLongHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenCharLongHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharLongHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenCharLongHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenCharLongHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenCharLongHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        long v;

        Pair(char k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

