/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharFloatProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenCharFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        OpenCharFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharFloatHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        OpenCharFloatHashMap map2 = (OpenCharFloatHashMap)map.clone();
        map.clear();
        OpenCharFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        OpenCharFloatHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharFloatHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        OpenCharFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenCharFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharFloatHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        map.forEachPair(new CharFloatProcedure(){

            public boolean apply(char first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharFloatHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharFloatHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharFloatHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharFloatHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6f);
        pairs.clear();
        map.forEachPair(new CharFloatProcedure(){
            int count = 0;

            public boolean apply(char first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        OpenCharFloatHashMapTest.assertEquals((double)22.0, (double)map.get('\u000b'), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((double)0.0, (double)map.get('\u0000'), (double)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.adjustOrPutValue('\u000b', 1.0f, 3.0f);
        OpenCharFloatHashMapTest.assertEquals((double)25.0, (double)map.get('\u000b'), (double)1.0E-6f);
        map.adjustOrPutValue('\u000f', 1.0f, 3.0f);
        OpenCharFloatHashMapTest.assertEquals((double)1.0, (double)map.get('\u000f'), (double)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 22.0f);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        map.pairsMatching(new CharFloatProcedure(){

            public boolean apply(char first, float second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharFloatHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharFloatHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharFloatHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenCharFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharFloatHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        OpenCharFloatHashMap map2 = (OpenCharFloatHashMap)map.copy();
        map.clear();
        OpenCharFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        OpenCharFloatHashMap map2 = (OpenCharFloatHashMap)map.copy();
        OpenCharFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 22.0f);
        map.put('\f', 23.0f);
        map.put('\r', 24.0f);
        map.put('\u000e', 25.0f);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharFloatHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharFloatHashMap map = new OpenCharFloatHashMap();
        map.put('\u000b', 100.0f);
        map.put('\f', 70.0f);
        map.put('\r', 30.0f);
        map.put('\u000e', 3.0f);
        CharArrayList keys = new CharArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharFloatHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharFloatHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharFloatHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharFloatHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharFloatHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharFloatHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharFloatHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharFloatHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6f);
        OpenCharFloatHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharFloatHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        float v;

        Pair(char k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

