/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharCharProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.OpenCharCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        OpenCharCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharCharHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        OpenCharCharHashMap map2 = (OpenCharCharHashMap)map.clone();
        map.clear();
        OpenCharCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        OpenCharCharHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharCharHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        OpenCharCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenCharCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharCharHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        map.forEachPair(new CharCharProcedure(){

            public boolean apply(char first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenCharCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenCharCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new CharCharProcedure(){
            int count = 0;

            public boolean apply(char first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        OpenCharCharHashMapTest.assertEquals((long)22L, (long)map.get('\u000b'));
        OpenCharCharHashMapTest.assertEquals((long)0L, (long)map.get('\u0000'));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.adjustOrPutValue('\u000b', '\u0001', '\u0003');
        OpenCharCharHashMapTest.assertEquals((long)25L, (long)map.get('\u000b'));
        map.adjustOrPutValue('\u000f', '\u0001', '\u0003');
        OpenCharCharHashMapTest.assertEquals((long)1L, (long)map.get('\u000f'));
    }

    @Test
    public void testKeys() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0016');
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        map.pairsMatching(new CharCharProcedure(){

            public boolean apply(char first, char second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharCharHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharCharHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenCharCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenCharCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenCharCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenCharCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        OpenCharCharHashMap map2 = (OpenCharCharHashMap)map.copy();
        map.clear();
        OpenCharCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        OpenCharCharHashMap map2 = (OpenCharCharHashMap)map.copy();
        OpenCharCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', '\u0016');
        map.put('\f', '\u0017');
        map.put('\r', '\u0018');
        map.put('\u000e', '\u0019');
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharCharHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharCharHashMap map = new OpenCharCharHashMap();
        map.put('\u000b', 'd');
        map.put('\f', 'F');
        map.put('\r', '\u001e');
        map.put('\u000e', '\u0003');
        CharArrayList keys = new CharArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenCharCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenCharCharHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenCharCharHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharCharHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenCharCharHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenCharCharHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenCharCharHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        char v;

        Pair(char k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

