/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteLongProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenByteLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        OpenByteLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteLongHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        OpenByteLongHashMap map2 = (OpenByteLongHashMap)map.clone();
        map.clear();
        OpenByteLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        OpenByteLongHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteLongHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        OpenByteLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenByteLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteLongHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        map.forEachPair(new ByteLongProcedure(){

            public boolean apply(byte first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenByteLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenByteLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ByteLongProcedure(){
            int count = 0;

            public boolean apply(byte first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        OpenByteLongHashMapTest.assertEquals((long)22L, (long)map.get((byte)11));
        OpenByteLongHashMapTest.assertEquals((long)0L, (long)map.get((byte)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.adjustOrPutValue((byte)11, 1L, 3L);
        OpenByteLongHashMapTest.assertEquals((long)25L, (long)map.get((byte)11));
        map.adjustOrPutValue((byte)15, 1L, 3L);
        OpenByteLongHashMapTest.assertEquals((long)1L, (long)map.get((byte)15));
    }

    @Test
    public void testKeys() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 22L);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteLongProcedure(){

            public boolean apply(byte first, long second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteLongHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteLongHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenByteLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenByteLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenByteLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenByteLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        OpenByteLongHashMap map2 = (OpenByteLongHashMap)map.copy();
        map.clear();
        OpenByteLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        OpenByteLongHashMap map2 = (OpenByteLongHashMap)map.copy();
        OpenByteLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 22L);
        map.put((byte)12, 23L);
        map.put((byte)13, 24L);
        map.put((byte)14, 25L);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteLongHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteLongHashMap map = new OpenByteLongHashMap();
        map.put((byte)11, 100L);
        map.put((byte)12, 70L);
        map.put((byte)13, 30L);
        map.put((byte)14, 3L);
        ByteArrayList keys = new ByteArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenByteLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenByteLongHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenByteLongHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteLongHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenByteLongHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenByteLongHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenByteLongHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        long v;

        Pair(byte k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

