/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.AbstractFloatList;
import org.apache.mahout.math.list.FloatArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatArrayListTest
extends Assert {
    private FloatArrayList emptyList;
    private FloatArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new FloatArrayList();
        this.listOfFive = new FloatArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((float)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, 1.0f);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, 0.0f);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add(12.0f);
        FloatArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((float)x % Float.MAX_VALUE);
        }
        FloatArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        FloatArrayListTest.assertEquals((double)12.0, (double)this.emptyList.get(0), (double)1.0);
        for (x = 0; x < 1000; ++x) {
            FloatArrayListTest.assertEquals((double)((float)x % Float.MAX_VALUE), (double)this.emptyList.get(x + 1), (double)1.0);
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo(0.0f, 2, 4);
        FloatArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo(1.0f, 0, 4);
        FloatArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        FloatArrayList l2 = this.listOfFive.copy();
        FloatArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        FloatArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        float[] l = new float[]{12.0f, 24.0f, 36.0f, 48.0f};
        FloatArrayList lar = new FloatArrayList(l);
        FloatArrayListTest.assertEquals((long)4L, (long)lar.size());
        FloatArrayListTest.assertSame((Object)l, (Object)lar.elements());
        float[] l2 = new float[]{3.0f, 6.0f, 9.0f, 12.0f};
        lar.elements(l2);
        FloatArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        float[] l = new float[]{12.0f, 24.0f, 36.0f, 48.0f};
        FloatArrayList lar = new FloatArrayList(l);
        FloatArrayList lar2 = new FloatArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        FloatArrayListTest.assertEquals((Object)lar, (Object)lar2);
        FloatArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add(55.0f);
        FloatArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new FloatProcedure(){
            int count;

            public boolean apply(float element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1.0f;
            }
        });
    }

    @Test
    public void testGetQuick() {
        FloatArrayList lar = new FloatArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo(0.0f, 2, 4);
        FloatArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo(1.0f, 0, 4);
        FloatArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        FloatArrayList lar = new FloatArrayList(10);
        lar.add(1.0f);
        lar.add(2.0f);
        lar.add(3.0f);
        lar.add(2.0f);
        lar.add(1.0f);
        FloatArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf(2.0f));
        FloatArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo(2.0f, 2, 4));
        FloatArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf(111.0f));
    }

    @Test
    public void testPartFromTo() {
        AbstractFloatList al = this.listOfFive.partFromTo(1, 2);
        FloatArrayListTest.assertEquals((long)2L, (long)al.size());
        FloatArrayListTest.assertEquals((double)1.0, (double)al.get(0), (double)1.0);
        FloatArrayListTest.assertEquals((double)2.0, (double)al.get(1), (double)1.0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        FloatArrayList lar = new FloatArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((float)x2);
        }
        FloatArrayList larOdd = new FloatArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((float)x);
        }
        lar.removeAll((AbstractFloatList)larOdd);
        FloatArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            FloatArrayListTest.assertEquals((double)(x * 2), (double)lar.get(x), (double)1.0);
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add(5.0f);
        FloatArrayList lar = new FloatArrayList();
        lar.add(44.0f);
        lar.add(55.0f);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractFloatList)lar, 0, 1);
        FloatArrayListTest.assertEquals((double)0.0, (double)this.listOfFive.get(0), (double)1.0);
        FloatArrayListTest.assertEquals((double)1.0, (double)this.listOfFive.get(1), (double)1.0);
        FloatArrayListTest.assertEquals((double)44.0, (double)this.listOfFive.get(2), (double)1.0);
        FloatArrayListTest.assertEquals((double)55.0, (double)this.listOfFive.get(3), (double)1.0);
        FloatArrayListTest.assertEquals((double)4.0, (double)this.listOfFive.get(4), (double)1.0);
        FloatArrayListTest.assertEquals((double)5.0, (double)this.listOfFive.get(5), (double)1.0);
    }

    @Test
    public void testRetainAllSmall() {
        FloatArrayList lar = new FloatArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        FloatArrayList lar2 = new FloatArrayList();
        lar2.add(3.0f);
        lar2.add(4.0f);
        FloatArrayListTest.assertTrue((boolean)lar.retainAll((AbstractFloatList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            float l = lar.get(x);
            FloatArrayListTest.assertTrue((l == 3.0f || l == 4.0f ? 1 : 0) != 0);
        }
        FloatArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        FloatArrayList lar = new FloatArrayList();
        lar.addAllOf(this.listOfFive);
        FloatArrayList lar2 = new FloatArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add(3.0f);
            lar2.add(4.0f);
        }
        FloatArrayListTest.assertTrue((boolean)lar.retainAll((AbstractFloatList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            float l = lar.get(x);
            FloatArrayListTest.assertTrue((l == 3.0f || l == 4.0f ? 1 : 0) != 0);
        }
    }
}

