/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.DistributionChecks;
import org.apache.mahout.math.jet.random.Normal;
import org.junit.Test;

public final class NormalTest
extends MahoutTestCase {
    private final double[] breaks = new double[]{-1.2815516, -0.8416212, -0.5244005, -0.2533471, 0.0, 0.2533471, 0.5244005, 0.8416212, 1.2815516};
    private final double[] quantiles = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};

    @Test
    public void testCdf() {
        Random gen = RandomUtils.getRandom();
        double offset = 0.0;
        double scale = 1.0;
        for (int k = 0; k < 20; ++k) {
            Normal dist = new Normal(offset, scale, null);
            DistributionChecks.checkCdf(offset, scale, (AbstractContinousDistribution)dist, this.breaks, this.quantiles);
            offset = gen.nextGaussian();
            scale = Math.exp(3.0 * gen.nextGaussian());
        }
    }

    @Test
    public void consistency() throws Exception {
        Random gen = RandomUtils.getRandom();
        double offset = 0.0;
        double scale = 1.0;
        Normal dist = new Normal(offset, scale, RandomUtils.getRandom());
        for (int k = 0; k < 20; ++k) {
            dist.setState(offset, scale);
            DistributionChecks.checkDistribution((AbstractContinousDistribution)dist, this.breaks, offset, scale, 10000);
            offset = gen.nextGaussian();
            scale = Math.exp(3.0 * gen.nextGaussian());
        }
    }

    @Test
    public void testSetState() throws Exception {
        Normal dist = new Normal(0.0, 1.0, RandomUtils.getRandom());
        dist.setState(1.3, 5.9);
        DistributionChecks.checkDistribution((AbstractContinousDistribution)dist, this.breaks, 1.3, 5.9, 10000);
    }

    @Test
    public void testToString() {
        NormalTest.assertEquals((Object)"org.apache.mahout.math.jet.random.Normal(m=1.300000, sd=5.900000)", (Object)new Normal(1.3, 5.9, null).toString());
    }
}

