/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Arrays;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.DistributionChecks;
import org.apache.mahout.math.jet.random.Exponential;
import org.junit.Test;

public final class ExponentialTest
extends MahoutTestCase {
    @Test
    public void consistency() throws Exception {
        Exponential dist = new Exponential(1.0, RandomUtils.getRandom());
        double[] breaks = new double[]{0.1053605, 0.2231436, 0.3566749, 0.5108256, 0.6931472, 0.9162907, 1.2039728, 1.6094379, 2.3025851};
        for (double lambda : new double[]{0.01, 0.1, 1.0, 2.0, 5.0, 100.0}) {
            dist.setState(lambda);
            DistributionChecks.checkDistribution((AbstractContinousDistribution)dist, breaks, 0.0, 1.0 / lambda, 10000);
        }
    }

    @Test
    public void testCdf() {
        Exponential dist = new Exponential(5.0, RandomUtils.getRandom());
        for (int i = 0; i < 1000; ++i) {
            double x = (double)i / 50.0;
            ExponentialTest.assertEquals((double)(1.0 - Math.exp(-x * 5.0)), (double)dist.cdf(x), (double)1.0E-9);
        }
    }

    @Test
    public void testPdf() {
        ExponentialTest.checkPdf(new Exponential(13.0, null), 13.0);
    }

    private static void checkPdf(Exponential dist, double lambda) {
        ExponentialTest.assertEquals((double)0.0, (double)dist.pdf(-1.0), (double)0.0);
        double sum = 0.0;
        double dx = 0.001 / lambda;
        for (double x = 0.0; x < 20.0 / lambda; x += dx) {
            sum += x * dist.pdf(x) * dx;
            ExponentialTest.assertEquals((double)(Math.exp(-x * lambda) * lambda), (double)dist.pdf(x), (double)1.0E-9);
        }
        ExponentialTest.assertEquals((double)(1.0 / lambda), (double)sum, (double)(1.0E-6 / lambda));
    }

    @Test
    public void testSetState() {
        Exponential dist = new Exponential(13.0, null);
        for (double lambda = 0.1; lambda < 1000.0; lambda *= 1.3) {
            dist.setState(lambda);
            ExponentialTest.checkPdf(dist, lambda);
        }
    }

    @Test
    public void testNextDouble() throws Exception {
        double[] x = new double[]{-0.01, 0.1053605, 0.2231436, 0.3566749, 0.5108256, 0.6931472, 0.9162907, 1.2039728, 1.6094379, 2.3025851};
        Exponential dist = new Exponential(1.0, RandomUtils.getRandom());
        for (double lambda : new double[]{13.0, 0.02, 1.6}) {
            dist.setState(lambda);
            ExponentialTest.checkEmpiricalDistribution(dist, 10000, lambda);
            DistributionChecks.checkDistribution((AbstractContinousDistribution)dist, x, 0.0, 1.0 / lambda, 10000);
        }
    }

    private static void checkEmpiricalDistribution(Exponential dist, int n, double lambda) {
        int i;
        double[] x = new double[n];
        for (i = 0; i < n; ++i) {
            x[i] = dist.nextDouble();
        }
        Arrays.sort(x);
        for (i = 0; i < n; ++i) {
            double cumulative = (double)i / (double)(n - 1);
            ExponentialTest.assertEquals((String)String.format("lambda = %.3f", lambda), (double)cumulative, (double)dist.cdf(x[i]), (double)0.02);
        }
    }

    @Test
    public void testToString() {
        ExponentialTest.assertEquals((Object)"org.apache.mahout.math.jet.random.Exponential(3.1000)", (Object)new Exponential(3.1, null).toString());
        ExponentialTest.assertEquals((Object)"org.apache.mahout.math.jet.random.Exponential(3.1000)", (Object)new Exponential(3.1, null).toString());
    }
}

