/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import java.util.Arrays;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.als.AlternatingLeastSquaresSolver;
import org.junit.Before;
import org.junit.Test;

public class AlternatingLeastSquaresSolverTest
extends MahoutTestCase {
    private AlternatingLeastSquaresSolver solver;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.solver = new AlternatingLeastSquaresSolver();
    }

    @Test
    public void addLambdaTimesNuiTimesE() {
        int nui = 5;
        double lambda = 0.2;
        SparseMatrix matrix = new SparseMatrix(5, 5);
        this.solver.addLambdaTimesNuiTimesE((Matrix)matrix, lambda, nui);
        for (int n = 0; n < 5; ++n) {
            AlternatingLeastSquaresSolverTest.assertEquals((double)1.0, (double)matrix.getQuick(n, n), (double)1.0E-6);
        }
    }

    @Test
    public void createMiIi() {
        DenseVector f1 = new DenseVector(new double[]{1.0, 2.0, 3.0});
        DenseVector f2 = new DenseVector(new double[]{4.0, 5.0, 6.0});
        Matrix miIi = this.solver.createMiIi(Arrays.asList(f1, f2), 3);
        AlternatingLeastSquaresSolverTest.assertEquals((double)1.0, (double)miIi.getQuick(0, 0), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)2.0, (double)miIi.getQuick(1, 0), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)3.0, (double)miIi.getQuick(2, 0), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)4.0, (double)miIi.getQuick(0, 1), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)5.0, (double)miIi.getQuick(1, 1), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)6.0, (double)miIi.getQuick(2, 1), (double)1.0E-6);
    }

    @Test
    public void createRiIiMaybeTransposed() {
        SequentialAccessSparseVector ratings = new SequentialAccessSparseVector(3);
        ratings.setQuick(1, 1.0);
        ratings.setQuick(3, 3.0);
        ratings.setQuick(5, 5.0);
        Matrix riIiMaybeTransposed = this.solver.createRiIiMaybeTransposed((Vector)ratings);
        AlternatingLeastSquaresSolverTest.assertEquals((double)1.0, (double)riIiMaybeTransposed.numCols(), (double)1.0);
        AlternatingLeastSquaresSolverTest.assertEquals((double)3.0, (double)riIiMaybeTransposed.numRows(), (double)3.0);
        AlternatingLeastSquaresSolverTest.assertEquals((double)1.0, (double)riIiMaybeTransposed.getQuick(0, 0), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)3.0, (double)riIiMaybeTransposed.getQuick(1, 0), (double)1.0E-6);
        AlternatingLeastSquaresSolverTest.assertEquals((double)5.0, (double)riIiMaybeTransposed.getQuick(2, 0), (double)1.0E-6);
    }

    @Test
    public void createRiIiMaybeTransposedExceptionOnNonSequentialVector() {
        RandomAccessSparseVector ratings = new RandomAccessSparseVector(3);
        ratings.setQuick(1, 1.0);
        ratings.setQuick(3, 3.0);
        ratings.setQuick(5, 5.0);
        try {
            this.solver.createRiIiMaybeTransposed((Vector)ratings);
            AlternatingLeastSquaresSolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

