/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.junit.Test;

public final class VectorTest
extends MahoutTestCase {
    @Test
    public void testSparseVector() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        RandomAccessSparseVector vec2 = new RandomAccessSparseVector(3);
        VectorTest.doTestVectors((Vector)vec1, (Vector)vec2);
    }

    @Test
    public void testSparseVectorFullIteration() {
        int i;
        int[] index = new int[]{0, 1, 2, 3, 4, 5};
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        VectorTest.assertEquals((long)index.length, (long)values.length);
        int n = index.length;
        SequentialAccessSparseVector vector = new SequentialAccessSparseVector(n);
        for (i = 0; i < n; ++i) {
            vector.set(index[i], values[i]);
        }
        for (i = 0; i < n; ++i) {
            VectorTest.assertEquals((double)vector.get(i), (double)values[i], (double)1.0E-6);
        }
        int elements = 0;
        for (Vector.Element e : vector) {
            ++elements;
        }
        VectorTest.assertEquals((long)n, (long)elements);
        VectorTest.assertFalse((boolean)new SequentialAccessSparseVector(0).iterator().hasNext());
    }

    @Test
    public void testSparseVectorSparseIteration() {
        int i;
        int[] index = new int[]{0, 1, 2, 3, 4, 5};
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        VectorTest.assertEquals((long)index.length, (long)values.length);
        int n = index.length;
        SequentialAccessSparseVector vector = new SequentialAccessSparseVector(n);
        for (i = 0; i < n; ++i) {
            vector.set(index[i], values[i]);
        }
        for (i = 0; i < n; ++i) {
            VectorTest.assertEquals((double)vector.get(i), (double)values[i], (double)1.0E-6);
        }
        int elements = 0;
        Iterator it = vector.iterateNonZero();
        while (it.hasNext()) {
            it.next();
            ++elements;
        }
        VectorTest.assertEquals((long)n, (long)elements);
        SequentialAccessSparseVector empty = new SequentialAccessSparseVector(0);
        VectorTest.assertFalse((boolean)empty.iterateNonZero().hasNext());
    }

    @Test
    public void testEquivalent() {
        RandomAccessSparseVector randomAccessLeft = new RandomAccessSparseVector(3);
        SequentialAccessSparseVector sequentialAccessLeft = new SequentialAccessSparseVector(3);
        DenseVector right = new DenseVector(3);
        randomAccessLeft.setQuick(0, 1.0);
        randomAccessLeft.setQuick(1, 2.0);
        randomAccessLeft.setQuick(2, 3.0);
        sequentialAccessLeft.setQuick(0, 1.0);
        sequentialAccessLeft.setQuick(1, 2.0);
        sequentialAccessLeft.setQuick(2, 3.0);
        right.setQuick(0, 1.0);
        right.setQuick(1, 2.0);
        right.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)randomAccessLeft, (Object)right);
        VectorTest.assertEquals((Object)sequentialAccessLeft, (Object)right);
        VectorTest.assertEquals((Object)sequentialAccessLeft, (Object)randomAccessLeft);
        DenseVector leftBar = new DenseVector(3);
        leftBar.setQuick(0, 1.0);
        leftBar.setQuick(1, 2.0);
        leftBar.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)leftBar, (Object)right);
        VectorTest.assertEquals((Object)randomAccessLeft, (Object)right);
        VectorTest.assertEquals((Object)sequentialAccessLeft, (Object)right);
        RandomAccessSparseVector rightBar = new RandomAccessSparseVector(3);
        rightBar.setQuick(0, 1.0);
        rightBar.setQuick(1, 2.0);
        rightBar.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)randomAccessLeft, (Object)rightBar);
        right.setQuick(2, 4.0);
        VectorTest.assertFalse((boolean)randomAccessLeft.equals((Object)right));
        right = new DenseVector(4);
        right.setQuick(0, 1.0);
        right.setQuick(1, 2.0);
        right.setQuick(2, 3.0);
        right.setQuick(3, 3.0);
        VectorTest.assertFalse((boolean)randomAccessLeft.equals((Object)right));
        randomAccessLeft = new RandomAccessSparseVector(2);
        randomAccessLeft.setQuick(0, 1.0);
        randomAccessLeft.setQuick(1, 2.0);
        VectorTest.assertFalse((boolean)randomAccessLeft.equals((Object)right));
        DenseVector dense = new DenseVector(3);
        right = new DenseVector(3);
        right.setQuick(0, 1.0);
        right.setQuick(1, 2.0);
        right.setQuick(2, 3.0);
        dense.setQuick(0, 1.0);
        dense.setQuick(1, 2.0);
        dense.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)dense, (Object)right);
        RandomAccessSparseVector sparse = new RandomAccessSparseVector(3);
        randomAccessLeft = new RandomAccessSparseVector(3);
        sparse.setQuick(0, 1.0);
        sparse.setQuick(1, 2.0);
        sparse.setQuick(2, 3.0);
        randomAccessLeft.setQuick(0, 1.0);
        randomAccessLeft.setQuick(1, 2.0);
        randomAccessLeft.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)randomAccessLeft, (Object)sparse);
        VectorView v1 = new VectorView((Vector)randomAccessLeft, 0, 2);
        VectorView v2 = new VectorView((Vector)right, 0, 2);
        VectorTest.assertEquals((Object)v1, (Object)v2);
        sparse = new RandomAccessSparseVector(2);
        sparse.setQuick(0, 1.0);
        sparse.setQuick(1, 2.0);
        VectorTest.assertEquals((Object)v1, (Object)sparse);
    }

    private static void doTestVectors(Vector left, Vector right) {
        left.setQuick(0, 1.0);
        left.setQuick(1, 2.0);
        left.setQuick(2, 3.0);
        right.setQuick(0, 4.0);
        right.setQuick(1, 5.0);
        right.setQuick(2, 6.0);
        double result = left.dot(right);
        VectorTest.assertEquals((double)32.0, (double)result, (double)1.0E-6);
    }

    @Test
    public void testGetDistanceSquared() {
        DenseVector v = new DenseVector(5);
        DenseVector w = new DenseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.setUpW((Vector)w);
        VectorTest.doTestGetDistanceSquared((Vector)v, (Vector)w);
        v = new RandomAccessSparseVector(5);
        w = new RandomAccessSparseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.setUpW((Vector)w);
        VectorTest.doTestGetDistanceSquared((Vector)v, (Vector)w);
        v = new SequentialAccessSparseVector(5);
        w = new SequentialAccessSparseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.setUpW((Vector)w);
        VectorTest.doTestGetDistanceSquared((Vector)v, (Vector)w);
    }

    @Test
    public void testAddTo() throws Exception {
        DenseVector v = new DenseVector(4);
        DenseVector w = new DenseVector(4);
        v.setQuick(0, 1.0);
        v.setQuick(1, 2.0);
        v.setQuick(2, 0.0);
        v.setQuick(3, 4.0);
        w.setQuick(0, 1.0);
        w.setQuick(1, 1.0);
        w.setQuick(2, 1.0);
        w.setQuick(3, 1.0);
        w.assign((Vector)v, Functions.PLUS);
        DenseVector gold = new DenseVector(new double[]{2.0, 3.0, 1.0, 5.0});
        VectorTest.assertEquals((Object)w, (Object)gold);
        VectorTest.assertFalse((boolean)v.equals(gold));
    }

    private static void setUpV(Vector v) {
        v.setQuick(1, 2.0);
        v.setQuick(2, -4.0);
        v.setQuick(3, -9.0);
    }

    private static void setUpW(Vector w) {
        w.setQuick(0, -5.0);
        w.setQuick(1, -1.0);
        w.setQuick(2, 9.0);
        w.setQuick(3, 0.1);
        w.setQuick(4, 2.1);
    }

    private static void doTestGetDistanceSquared(Vector v, Vector w) {
        double expected = v.minus(w).getLengthSquared();
        VectorTest.assertEquals((double)expected, (double)v.getDistanceSquared(w), (double)1.0E-6);
    }

    @Test
    public void testGetLengthSquared() {
        DenseVector v = new DenseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.doTestGetLengthSquared((Vector)v);
        v = new RandomAccessSparseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.doTestGetLengthSquared((Vector)v);
        v = new SequentialAccessSparseVector(5);
        VectorTest.setUpV((Vector)v);
        VectorTest.doTestGetLengthSquared((Vector)v);
    }

    public static double lengthSquaredSlowly(Vector v) {
        double d = 0.0;
        for (int i = 0; i < v.size(); ++i) {
            double value = v.get(i);
            d += value * value;
        }
        return d;
    }

    private static void doTestGetLengthSquared(Vector v) {
        double expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"v.getLengthSquared() != sum_of_squared_elements(v)", (double)expected, (double)v.getLengthSquared(), (double)0.0);
        v.set(v.size() / 2, v.get(v.size() / 2) + 1.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via set() fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.setQuick(v.size() / 5, v.get(v.size() / 5) + 1.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via setQuick() fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        for (Vector.Element e : v) {
            if (e.index() != v.size() - 2) continue;
            e.set(e.get() - 5.0);
        }
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via dense iterator.set fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        Iterator it = v.iterateNonZero();
        int i = 0;
        while (it.hasNext()) {
            Vector.Element e = (Vector.Element)it.next();
            if (++i != v.getNumNondefaultElements() - 1) continue;
            e.set(e.get() - 5.0);
        }
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via sparse iterator.set fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.assign(3.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via assign(double) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.assign(Functions.SQUARE);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via assign(square) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.assign(new double[v.size()]);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via assign(double[]) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.getElement(v.size() / 2).set(2.5);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via v.getElement().set() fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.normalize();
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via normalize() fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.set(0, 1.5);
        v.normalize(1.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via normalize(double) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.times(2.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via times(double) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.times(v);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via times(vector) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.assign(Functions.POW, 3.0);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via assign(pow, 3.0) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
        v.assign(v, Functions.PLUS);
        expected = VectorTest.lengthSquaredSlowly(v);
        VectorTest.assertEquals((String)"mutation via assign(v,plus) fails to change lengthSquared", (double)expected, (double)v.getLengthSquared(), (double)1.0E-6);
    }

    @Test
    public void testIterator() {
        int i;
        HashSet<Integer> expectedIndices = new HashSet<Integer>();
        for (i = 1; i <= 20; ++i) {
            expectedIndices.add(i * (i + 1) / 2);
        }
        DenseVector denseVector = new DenseVector(i * i);
        Iterator i$ = expectedIndices.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            denseVector.set(index, 2.0 * (double)index);
        }
        VectorTest.doTestIterators((Vector)denseVector, expectedIndices);
        RandomAccessSparseVector randomAccessVector = new RandomAccessSparseVector(i * i);
        Iterator i$2 = expectedIndices.iterator();
        while (i$2.hasNext()) {
            int index = (Integer)i$2.next();
            randomAccessVector.set(index, 2.0 * (double)index);
        }
        VectorTest.doTestIterators((Vector)randomAccessVector, expectedIndices);
        SequentialAccessSparseVector sequentialVector = new SequentialAccessSparseVector(i * i);
        Iterator i$3 = expectedIndices.iterator();
        while (i$3.hasNext()) {
            int index = (Integer)i$3.next();
            sequentialVector.set(index, 2.0 * (double)index);
        }
        VectorTest.doTestIterators((Vector)sequentialVector, expectedIndices);
    }

    private static void doTestIterators(Vector vector, Collection<Integer> expectedIndices) {
        expectedIndices = new HashSet<Integer>(expectedIndices);
        Iterator allIterator = vector.iterator();
        int index = 0;
        while (allIterator.hasNext()) {
            Vector.Element element = (Vector.Element)allIterator.next();
            VectorTest.assertEquals((long)index, (long)element.index());
            if (expectedIndices.contains(index)) {
                VectorTest.assertEquals((double)((double)index * 2.0), (double)element.get(), (double)1.0E-6);
            } else {
                VectorTest.assertEquals((double)0.0, (double)element.get(), (double)1.0E-6);
            }
            ++index;
        }
        Iterator nonZeroIterator = vector.iterateNonZero();
        while (nonZeroIterator.hasNext()) {
            Vector.Element element = (Vector.Element)nonZeroIterator.next();
            index = element.index();
            VectorTest.assertTrue((boolean)expectedIndices.contains(index));
            VectorTest.assertEquals((double)((double)index * 2.0), (double)element.get(), (double)1.0E-6);
            expectedIndices.remove(index);
        }
        VectorTest.assertTrue((boolean)expectedIndices.isEmpty());
    }

    @Test
    public void testNormalize() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, 1.0);
        vec1.setQuick(1, 2.0);
        vec1.setQuick(2, 3.0);
        Vector norm = vec1.normalize();
        VectorTest.assertNotNull((String)"norm1 is null and it shouldn't be", (Object)norm);
        SequentialAccessSparseVector vec2 = new SequentialAccessSparseVector(3);
        vec2.setQuick(0, 1.0);
        vec2.setQuick(1, 2.0);
        vec2.setQuick(2, 3.0);
        Vector norm2 = vec2.normalize();
        VectorTest.assertNotNull((String)"norm1 is null and it shouldn't be", (Object)norm2);
        RandomAccessSparseVector expected = new RandomAccessSparseVector(3);
        expected.setQuick(0, 0.2672612419124244);
        expected.setQuick(1, 0.5345224838248488);
        expected.setQuick(2, 0.8017837257372732);
        VectorTest.assertEquals((Object)expected, (Object)norm);
        norm = vec1.normalize(2.0);
        VectorTest.assertEquals((Object)expected, (Object)norm);
        norm2 = vec2.normalize(2.0);
        VectorTest.assertEquals((Object)expected, (Object)norm2);
        norm = vec1.normalize(1.0);
        norm2 = vec2.normalize(1.0);
        expected.setQuick(0, 0.16666666666666666);
        expected.setQuick(1, 0.3333333333333333);
        expected.setQuick(2, 0.5);
        VectorTest.assertEquals((Object)expected, (Object)norm);
        VectorTest.assertEquals((Object)expected, (Object)norm2);
        norm = vec1.normalize(3.0);
        double cube = Math.pow(36.0, 0.3333333333333333);
        expected = vec1.divide(cube);
        VectorTest.assertEquals((Object)norm, (Object)expected);
        norm = vec1.normalize(Double.POSITIVE_INFINITY);
        norm2 = vec2.normalize(Double.POSITIVE_INFINITY);
        expected.setQuick(0, 0.3333333333333333);
        expected.setQuick(1, 0.6666666666666666);
        expected.setQuick(2, 1.0);
        VectorTest.assertEquals((Object)norm, (Object)expected);
        VectorTest.assertEquals((Object)norm2, (Object)expected);
        norm = vec1.normalize(0.0);
        expected.setQuick(0, 0.3333333333333333);
        expected.setQuick(1, 0.6666666666666666);
        expected.setQuick(2, 1.0);
        VectorTest.assertEquals((Object)norm, (Object)expected);
        try {
            vec1.normalize(-1.0);
            VectorTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            vec2.normalize(-1.0);
            VectorTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testLogNormalize() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, 1.0);
        vec1.setQuick(1, 2.0);
        vec1.setQuick(2, 3.0);
        Vector norm = vec1.logNormalize();
        VectorTest.assertNotNull((String)"norm1 is null and it shouldn't be", (Object)norm);
        SequentialAccessSparseVector vec2 = new SequentialAccessSparseVector(3);
        vec2.setQuick(0, 1.0);
        vec2.setQuick(1, 2.0);
        vec2.setQuick(2, 3.0);
        Vector norm2 = vec2.logNormalize();
        VectorTest.assertNotNull((String)"norm1 is null and it shouldn't be", (Object)norm2);
        DenseVector expected = new DenseVector(new double[]{0.2672612419124244, 0.4235990463273581, 0.5345224838248488});
        VectorTest.assertVectorEquals((Vector)expected, norm, 1.0E-15);
        VectorTest.assertVectorEquals((Vector)expected, norm2, 1.0E-15);
        norm = vec1.logNormalize(2.0);
        VectorTest.assertVectorEquals((Vector)expected, norm, 1.0E-15);
        norm2 = vec2.logNormalize(2.0);
        VectorTest.assertVectorEquals((Vector)expected, norm2, 1.0E-15);
        try {
            vec1.logNormalize(1.0);
            VectorTest.fail((String)"Should fail with power == 1");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            vec1.logNormalize(-1.0);
            VectorTest.fail((String)"Should fail with negative power");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            vec2.logNormalize(Double.POSITIVE_INFINITY);
            VectorTest.fail((String)"Should fail with positive infinity norm");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private static void assertVectorEquals(Vector expected, Vector actual, double epsilon) {
        VectorTest.assertEquals((long)expected.size(), (long)actual.size());
        for (Vector.Element x : expected) {
            VectorTest.assertEquals((double)x.get(), (double)actual.get(x.index()), (double)epsilon);
        }
    }

    @Test
    public void testMax() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(1, -3.0);
        vec1.setQuick(2, -2.0);
        double max = vec1.maxValue();
        VectorTest.assertEquals((double)-1.0, (double)max, (double)0.0);
        int idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)0L, (long)idx);
        vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new SequentialAccessSparseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new DenseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new RandomAccessSparseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new DenseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new SequentialAccessSparseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new RandomAccessSparseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
        vec1 = new DenseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
        vec1 = new SequentialAccessSparseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
    }

    @Test
    public void testMin() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, 1.0);
        vec1.setQuick(1, 3.0);
        vec1.setQuick(2, 2.0);
        double max = vec1.minValue();
        VectorTest.assertEquals((double)1.0, (double)max, (double)0.0);
        int idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new RandomAccessSparseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new SequentialAccessSparseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new DenseVector(3);
        vec1.setQuick(0, -1.0);
        vec1.setQuick(2, -2.0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)0.0);
        idx = vec1.maxValueIndex();
        VectorTest.assertEquals((long)1L, (long)idx);
        vec1 = new RandomAccessSparseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new DenseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new SequentialAccessSparseVector(3);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)0.0, (double)max, (double)1.0E-6);
        vec1 = new RandomAccessSparseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
        vec1 = new DenseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
        vec1 = new SequentialAccessSparseVector(0);
        max = vec1.maxValue();
        VectorTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max, (double)1.0E-6);
    }

    @Test
    public void testDenseVector() {
        DenseVector vec1 = new DenseVector(3);
        DenseVector vec2 = new DenseVector(3);
        VectorTest.doTestVectors((Vector)vec1, (Vector)vec2);
    }

    @Test
    public void testVectorView() {
        RandomAccessSparseVector vec1 = new RandomAccessSparseVector(3);
        RandomAccessSparseVector vec2 = new RandomAccessSparseVector(6);
        SequentialAccessSparseVector vec3 = new SequentialAccessSparseVector(3);
        SequentialAccessSparseVector vec4 = new SequentialAccessSparseVector(6);
        VectorView vecV1 = new VectorView((Vector)vec1, 0, 3);
        VectorView vecV2 = new VectorView((Vector)vec2, 2, 3);
        VectorView vecV3 = new VectorView((Vector)vec3, 0, 3);
        VectorView vecV4 = new VectorView((Vector)vec4, 2, 3);
        VectorTest.doTestVectors((Vector)vecV1, (Vector)vecV2);
        VectorTest.doTestVectors((Vector)vecV3, (Vector)vecV4);
    }

    private static void doTestEnumeration(double[] apriori, Vector vector) {
        double[] test = new double[apriori.length];
        Iterator iter = vector.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = (Vector.Element)iter.next();
            test[e.index()] = e.get();
        }
        for (int i = 0; i < test.length; ++i) {
            VectorTest.assertEquals((double)apriori[i], (double)test[i], (double)1.0E-6);
        }
    }

    @Test
    public void testEnumeration() {
        double[] apriori = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        VectorTest.doTestEnumeration(apriori, (Vector)new VectorView((Vector)new DenseVector(new double[]{-2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}), 2, 5));
        VectorTest.doTestEnumeration(apriori, (Vector)new DenseVector(new double[]{0.0, 1.0, 2.0, 3.0, 4.0}));
        RandomAccessSparseVector sparse = new RandomAccessSparseVector(5);
        sparse.set(0, 0.0);
        sparse.set(1, 1.0);
        sparse.set(2, 2.0);
        sparse.set(3, 3.0);
        sparse.set(4, 4.0);
        VectorTest.doTestEnumeration(apriori, (Vector)sparse);
        sparse = new SequentialAccessSparseVector(5);
        sparse.set(0, 0.0);
        sparse.set(1, 1.0);
        sparse.set(2, 2.0);
        sparse.set(3, 3.0);
        sparse.set(4, 4.0);
        VectorTest.doTestEnumeration(apriori, (Vector)sparse);
    }

    @Test
    public void testAggregation() {
        DenseVector v = new DenseVector(5);
        DenseVector w = new DenseVector(5);
        VectorTest.setUpFirstVector((Vector)v);
        VectorTest.setUpSecondVector((Vector)w);
        VectorTest.doTestAggregation((Vector)v, (Vector)w);
        v = new RandomAccessSparseVector(5);
        w = new RandomAccessSparseVector(5);
        VectorTest.setUpFirstVector((Vector)v);
        VectorTest.doTestAggregation((Vector)v, (Vector)w);
        VectorTest.setUpSecondVector((Vector)w);
        VectorTest.doTestAggregation((Vector)w, (Vector)v);
        v = new SequentialAccessSparseVector(5);
        w = new SequentialAccessSparseVector(5);
        VectorTest.setUpFirstVector((Vector)v);
        VectorTest.doTestAggregation((Vector)v, (Vector)w);
        VectorTest.setUpSecondVector((Vector)w);
        VectorTest.doTestAggregation((Vector)w, (Vector)v);
    }

    private static void doTestAggregation(Vector v, Vector w) {
        VectorTest.assertEquals((String)("aggregate(plus, pow(2)) not equal to " + v.getLengthSquared()), (double)v.getLengthSquared(), (double)v.aggregate(Functions.PLUS, Functions.pow((double)2.0)), (double)1.0E-6);
        VectorTest.assertEquals((String)("aggregate(plus, abs) not equal to " + v.norm(1.0)), (double)v.norm(1.0), (double)v.aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-6);
        VectorTest.assertEquals((String)("aggregate(max, abs) not equal to " + v.norm(Double.POSITIVE_INFINITY)), (double)v.norm(Double.POSITIVE_INFINITY), (double)v.aggregate(Functions.MAX, Functions.ABS), (double)1.0E-6);
        VectorTest.assertEquals((String)"v.dot(w) != v.aggregate(w, plus, mult)", (double)v.dot(w), (double)v.aggregate(w, Functions.PLUS, Functions.MULT), (double)1.0E-6);
        VectorTest.assertEquals((String)"|(v-w)|^2 != v.aggregate(w, plus, chain(pow(2), minus))", (double)v.minus(w).dot(v.minus(w)), (double)v.aggregate(w, Functions.PLUS, Functions.chain((DoubleFunction)Functions.pow((double)2.0), (DoubleDoubleFunction)Functions.MINUS)), (double)1.0E-6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyAggregate1() {
        VectorTest.assertEquals((double)1.0, (double)new DenseVector(new double[]{1.0}).aggregate(Functions.MIN, Functions.IDENTITY), (double)1.0E-6);
        VectorTest.assertEquals((double)1.0, (double)new DenseVector(new double[]{2.0, 1.0}).aggregate(Functions.MIN, Functions.IDENTITY), (double)1.0E-6);
        new DenseVector(new double[0]).aggregate(Functions.MIN, Functions.IDENTITY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyAggregate2() {
        VectorTest.assertEquals((double)3.0, (double)new DenseVector(new double[]{1.0}).aggregate((Vector)new DenseVector(new double[]{2.0}), Functions.MIN, Functions.PLUS), (double)1.0E-6);
        new DenseVector(new double[0]).aggregate((Vector)new DenseVector(new double[0]), Functions.MIN, Functions.PLUS);
    }

    private static void setUpFirstVector(Vector v) {
        v.setQuick(1, 2.0);
        v.setQuick(2, 0.5);
        v.setQuick(3, -5.0);
    }

    private static void setUpSecondVector(Vector v) {
        v.setQuick(0, 3.0);
        v.setQuick(1, -1.5);
        v.setQuick(2, -5.0);
        v.setQuick(3, 2.0);
    }

    @Test
    public void testHashCodeEquivalence() {
        RandomAccessSparseVector sparseLeft = new RandomAccessSparseVector(3);
        DenseVector denseRight = new DenseVector(3);
        sparseLeft.setQuick(0, 1.0);
        sparseLeft.setQuick(1, 2.0);
        sparseLeft.setQuick(2, 3.0);
        denseRight.setQuick(0, 1.0);
        denseRight.setQuick(1, 2.0);
        denseRight.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)sparseLeft, (Object)denseRight);
        VectorTest.assertEquals((long)sparseLeft.hashCode(), (long)denseRight.hashCode());
        sparseLeft = new SequentialAccessSparseVector(3);
        sparseLeft.setQuick(0, 1.0);
        sparseLeft.setQuick(1, 2.0);
        sparseLeft.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)sparseLeft, (Object)denseRight);
        VectorTest.assertEquals((long)sparseLeft.hashCode(), (long)denseRight.hashCode());
        DenseVector denseLeft = new DenseVector(3);
        denseLeft.setQuick(0, 1.0);
        denseLeft.setQuick(1, 2.0);
        denseLeft.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)denseLeft, (Object)denseRight);
        VectorTest.assertEquals((long)denseLeft.hashCode(), (long)denseRight.hashCode());
        SequentialAccessSparseVector sparseRight = new SequentialAccessSparseVector(3);
        sparseRight.setQuick(0, 1.0);
        sparseRight.setQuick(1, 2.0);
        sparseRight.setQuick(2, 3.0);
        VectorTest.assertEquals((Object)sparseLeft, (Object)sparseRight);
        VectorTest.assertEquals((long)sparseLeft.hashCode(), (long)sparseRight.hashCode());
        DenseVector emptyLeft = new DenseVector(0);
        SequentialAccessSparseVector emptyRight = new SequentialAccessSparseVector(0);
        VectorTest.assertEquals((Object)emptyLeft, (Object)emptyRight);
        VectorTest.assertEquals((long)emptyLeft.hashCode(), (long)emptyRight.hashCode());
        emptyRight = new RandomAccessSparseVector(0);
        VectorTest.assertEquals((Object)emptyLeft, (Object)emptyRight);
        VectorTest.assertEquals((long)emptyLeft.hashCode(), (long)emptyRight.hashCode());
    }

    @Test
    public void testHashCode() {
        SequentialAccessSparseVector left = new SequentialAccessSparseVector(3);
        SequentialAccessSparseVector right = new SequentialAccessSparseVector(3);
        left.setQuick(0, 1.0);
        left.setQuick(2, 2.0);
        right.setQuick(0, 1.0);
        right.setQuick(1, 2.0);
        VectorTest.assertFalse((boolean)left.equals(right));
        VectorTest.assertFalse((left.hashCode() == right.hashCode() ? 1 : 0) != 0);
        left = new RandomAccessSparseVector(3);
        right = new RandomAccessSparseVector(3);
        left.setQuick(0, 1.0);
        left.setQuick(2, 2.0);
        right.setQuick(0, 1.0);
        right.setQuick(1, 2.0);
        VectorTest.assertFalse((boolean)left.equals(right));
        VectorTest.assertFalse((left.hashCode() == right.hashCode() ? 1 : 0) != 0);
        right = new SequentialAccessSparseVector(5);
        right.setQuick(0, 1.0);
        right.setQuick(2, 2.0);
        VectorTest.assertFalse((boolean)left.equals(right));
        VectorTest.assertFalse((left.hashCode() == right.hashCode() ? 1 : 0) != 0);
        right = new RandomAccessSparseVector(5);
        right.setQuick(0, 1.0);
        right.setQuick(2, 2.0);
        VectorTest.assertFalse((boolean)left.equals(right));
        VectorTest.assertFalse((left.hashCode() == right.hashCode() ? 1 : 0) != 0);
    }
}

