/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.junit.Before;
import org.junit.Test;

public final class TestMatrixView
extends MahoutTestCase {
    private static final int ROW = 0;
    private static final int COL = 1;
    private final double[][] values = new double[][]{{0.0, 1.1, 2.2}, {1.1, 2.2, 3.3}, {3.3, 4.4, 5.5}, {5.5, 6.6, 7.7}, {7.7, 8.8, 9.9}};
    private Matrix test;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        int[] offset = new int[]{1, 1};
        int[] card = new int[]{3, 2};
        this.test = new MatrixView((Matrix)new DenseMatrix(this.values), offset, card);
    }

    @Test
    public void testCardinality() {
        TestMatrixView.assertEquals((String)"row cardinality", (long)(this.values.length - 2), (long)this.test.rowSize());
        TestMatrixView.assertEquals((String)"col cardinality", (long)(this.values[0].length - 1), (long)this.test.columnSize());
    }

    @Test
    public void testCopy() {
        Matrix copy = this.test.clone();
        TestMatrixView.assertTrue((String)"wrong class", (boolean)(copy instanceof MatrixView));
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)copy.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testGetQuick() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row + 1][col + 1], (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testLike() {
        Matrix like = this.test.like();
        TestMatrixView.assertTrue((String)"type", (boolean)(like instanceof DenseMatrix));
        TestMatrixView.assertEquals((String)"rows", (long)this.test.rowSize(), (long)like.rowSize());
        TestMatrixView.assertEquals((String)"columns", (long)this.test.columnSize(), (long)like.columnSize());
    }

    @Test
    public void testLikeIntInt() {
        Matrix like = this.test.like(4, 4);
        TestMatrixView.assertTrue((String)"type", (boolean)(like instanceof DenseMatrix));
        TestMatrixView.assertEquals((String)"rows", (long)4L, (long)like.rowSize());
        TestMatrixView.assertEquals((String)"columns", (long)4L, (long)like.columnSize());
    }

    @Test
    public void testSetQuick() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.setQuick(row, col, 1.23);
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)1.23, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSize() {
        TestMatrixView.assertEquals((String)"row size", (long)(this.values.length - 2), (long)this.test.rowSize());
        TestMatrixView.assertEquals((String)"col size", (long)(this.values[0].length - 1), (long)this.test.columnSize());
    }

    @Test
    public void testViewPart() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 1};
        Matrix view = this.test.viewPart(offset, size);
        for (int row = 0; row < view.rowSize(); ++row) {
            for (int col = 0; col < view.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row + 2][col + 2], (double)view.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{3, 3};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexOver() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexUnder() {
        int[] offset = new int[]{-1, -1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test
    public void testAssignDouble() {
        this.test.assign(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)4.53, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testAssignDoubleArrayArray() {
        this.test.assign(new double[3][2]);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayArrayCardinality() {
        this.test.assign(new double[this.test.rowSize() + 1][this.test.columnSize()]);
    }

    @Test
    public void testAssignMatrixBinaryFunction() {
        this.test.assign(this.test, Functions.PLUS);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(2.0 * this.values[row + 1][col + 1]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixBinaryFunctionCardinality() {
        this.test.assign(this.test.transpose(), Functions.PLUS);
    }

    @Test
    public void testAssignMatrix() {
        Matrix value = this.test.like();
        value.assign(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixCardinality() {
        this.test.assign(this.test.transpose());
    }

    @Test
    public void testAssignUnaryFunction() {
        this.test.assign(Functions.NEGATE);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(-this.values[row + 1][col + 1]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testDivide() {
        Matrix value = this.test.divide(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row + 1][col + 1] / 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testGet() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row + 1][col + 1], (double)this.test.get(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexUnder() {
        for (int row = -1; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexOver() {
        for (int row = 0; row < this.test.rowSize() + 1; ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test
    public void testMinus() {
        Matrix value = this.test.minus(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testMinusCardinality() {
        this.test.minus(this.test.transpose());
    }

    @Test
    public void testPlusDouble() {
        Matrix value = this.test.plus(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row + 1][col + 1] + 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testPlusMatrix() {
        Matrix value = this.test.plus(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row + 1][col + 1] * 2.0), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusMatrixCardinality() {
        this.test.plus(this.test.transpose());
    }

    @Test(expected=IndexException.class)
    public void testSetUnder() {
        for (int row = -1; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testSetOver() {
        for (int row = 0; row < this.test.rowSize() + 1; ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test
    public void testTimesDouble() {
        Matrix value = this.test.times(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row + 1][col + 1] * 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testTimesMatrix() {
        Matrix transpose = this.test.transpose();
        Matrix value = this.test.times(transpose);
        TestMatrixView.assertEquals((String)"rows", (long)this.test.rowSize(), (long)value.rowSize());
        TestMatrixView.assertEquals((String)"cols", (long)this.test.rowSize(), (long)value.columnSize());
    }

    @Test(expected=CardinalityException.class)
    public void testTimesMatrixCardinality() {
        Matrix other = this.test.like(5, 8);
        this.test.times(other);
    }

    @Test
    public void testTranspose() {
        Matrix transpose = this.test.transpose();
        TestMatrixView.assertEquals((String)"rows", (long)this.test.columnSize(), (long)transpose.rowSize());
        TestMatrixView.assertEquals((String)"cols", (long)this.test.rowSize(), (long)transpose.columnSize());
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                TestMatrixView.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)transpose.getQuick(col, row), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testZSum() {
        double sum = this.test.zSum();
        TestMatrixView.assertEquals((String)"zsum", (double)29.7, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testAssignRow() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignRow(1, (Vector)new DenseVector(data));
        TestMatrixView.assertEquals((String)"test[1][0]", (double)2.1, (double)this.test.getQuick(1, 0), (double)1.0E-6);
        TestMatrixView.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignRowCardinality() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignRow(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testAssignColumn() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
        TestMatrixView.assertEquals((String)"test[0][1]", (double)2.1, (double)this.test.getQuick(0, 1), (double)1.0E-6);
        TestMatrixView.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
        TestMatrixView.assertEquals((String)"test[2][1]", (double)4.3, (double)this.test.getQuick(2, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignColumnCardinality() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testViewRow() {
        Vector row = this.test.viewRow(1);
        TestMatrixView.assertEquals((String)"row size", (long)2L, (long)row.getNumNondefaultElements());
    }

    @Test(expected=IndexException.class)
    public void testViewRowIndexUnder() {
        this.test.viewRow(-1);
    }

    @Test(expected=IndexException.class)
    public void testViewRowIndexOver() {
        this.test.viewRow(5);
    }

    @Test
    public void testViewColumn() {
        Vector column = this.test.viewColumn(1);
        TestMatrixView.assertEquals((String)"row size", (long)3L, (long)column.getNumNondefaultElements());
        int i = 0;
        for (double x : new double[]{3.3, 5.5, 7.7}) {
            TestMatrixView.assertEquals((double)x, (double)column.get(i++), (double)0.0);
        }
    }

    @Test(expected=IndexException.class)
    public void testViewColumnIndexUnder() {
        this.test.viewColumn(-1);
    }

    @Test(expected=IndexException.class)
    public void testViewColumnIndexOver() {
        this.test.viewColumn(5);
    }

    @Test
    public void testLabelBindings() {
        TestMatrixView.assertNull((String)"row bindings", (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertNull((String)"col bindings", (Object)this.test.getColumnLabelBindings());
        HashMap rowBindings = Maps.newHashMap();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        this.test.setRowLabelBindings((Map)rowBindings);
        TestMatrixView.assertEquals((String)"row", (Object)rowBindings, (Object)this.test.getRowLabelBindings());
        HashMap colBindings = Maps.newHashMap();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        this.test.setColumnLabelBindings((Map)colBindings);
        TestMatrixView.assertEquals((String)"row", (Object)rowBindings, (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertEquals((String)"Fee", (double)this.test.get(0, 1), (double)this.test.get("Fee", "Bar"), (double)1.0E-6);
        double[] newrow = new double[]{9.0, 8.0};
        this.test.set("Fie", newrow);
        TestMatrixView.assertEquals((String)"FeeBar", (double)this.test.get(0, 1), (double)this.test.get("Fee", "Bar"), (double)1.0E-6);
    }

    @Test(expected=IllegalStateException.class)
    public void testSettingLabelBindings() {
        TestMatrixView.assertNull((String)"row bindings", (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertNull((String)"col bindings", (Object)this.test.getColumnLabelBindings());
        this.test.set("Fee", "Foo", 1, 1, 9.0);
        TestMatrixView.assertNotNull((String)"row", (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertNotNull((String)"row", (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertEquals((String)"Fee", (long)1L, (long)((Integer)this.test.getRowLabelBindings().get("Fee")).intValue());
        TestMatrixView.assertEquals((String)"Foo", (long)1L, (long)((Integer)this.test.getColumnLabelBindings().get("Foo")).intValue());
        TestMatrixView.assertEquals((String)"FeeFoo", (double)this.test.get(1, 1), (double)this.test.get("Fee", "Foo"), (double)1.0E-6);
        this.test.get("Fie", "Foe");
    }

    @Test
    public void testLabelBindingSerialization() {
        TestMatrixView.assertNull((String)"row bindings", (Object)this.test.getRowLabelBindings());
        TestMatrixView.assertNull((String)"col bindings", (Object)this.test.getColumnLabelBindings());
        HashMap rowBindings = Maps.newHashMap();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        rowBindings.put("Foe", 2);
        this.test.setRowLabelBindings((Map)rowBindings);
        TestMatrixView.assertEquals((String)"row", (Object)rowBindings, (Object)this.test.getRowLabelBindings());
        HashMap colBindings = Maps.newHashMap();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        colBindings.put("Baz", 2);
        this.test.setColumnLabelBindings((Map)colBindings);
        TestMatrixView.assertEquals((String)"col", (Object)colBindings, (Object)this.test.getColumnLabelBindings());
    }
}

