/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestVector
extends MahoutTestCase {
    private static final double[] values = new double[]{1.1, 2.2, 3.3};
    private static final double[] gold = new double[]{0.0, 1.1, 0.0, 2.2, 0.0, 3.3, 0.0};
    private Vector test;

    abstract Vector generateTestVector(int var1);

    Vector getTestVector() {
        return this.test;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.test = this.generateTestVector(2 * values.length + 1);
        for (int i = 0; i < values.length; ++i) {
            this.test.set(2 * i + 1, values[i]);
        }
    }

    @Test
    public void testCardinality() {
        AbstractTestVector.assertEquals((String)"size", (long)7L, (long)this.test.size());
    }

    @Test
    public void testIterator() {
        int i;
        Iterator iterator = this.test.iterateNonZero();
        AbstractTestVector.checkIterator(iterator, gold);
        iterator = this.test.iterator();
        AbstractTestVector.checkIterator(iterator, gold);
        double[] doubles = new double[]{0.0, 5.0, 0.0, 3.0};
        RandomAccessSparseVector zeros = new RandomAccessSparseVector(doubles.length);
        for (i = 0; i < doubles.length; ++i) {
            zeros.setQuick(i, doubles[i]);
        }
        iterator = zeros.iterateNonZero();
        AbstractTestVector.checkIterator(iterator, doubles);
        iterator = zeros.iterator();
        AbstractTestVector.checkIterator(iterator, doubles);
        doubles = new double[]{0.0, 0.0, 0.0, 0.0};
        zeros = new RandomAccessSparseVector(doubles.length);
        for (i = 0; i < doubles.length; ++i) {
            zeros.setQuick(i, doubles[i]);
        }
        iterator = zeros.iterateNonZero();
        AbstractTestVector.checkIterator(iterator, doubles);
        iterator = zeros.iterator();
        AbstractTestVector.checkIterator(iterator, doubles);
    }

    private static void checkIterator(Iterator<Vector.Element> nzIter, double[] values) {
        while (nzIter.hasNext()) {
            Vector.Element elt = nzIter.next();
            AbstractTestVector.assertEquals((String)(elt.index() + " Value: " + values[elt.index()] + " does not equal: " + elt.get()), (double)values[elt.index()], (double)elt.get(), (double)0.0);
        }
    }

    @Test
    public void testIteratorSet() {
        Vector.Element e2;
        Vector clone = this.test.clone();
        Iterator it = clone.iterateNonZero();
        while (it.hasNext()) {
            e2 = (Vector.Element)it.next();
            e2.set(e2.get() * 2.0);
        }
        it = clone.iterateNonZero();
        while (it.hasNext()) {
            e2 = (Vector.Element)it.next();
            AbstractTestVector.assertEquals((double)(this.test.get(e2.index()) * 2.0), (double)e2.get(), (double)1.0E-6);
        }
        clone = this.test.clone();
        for (Vector.Element e2 : clone) {
            e2.set(e2.get() * 2.0);
        }
        for (Vector.Element e2 : clone) {
            AbstractTestVector.assertEquals((double)(this.test.get(e2.index()) * 2.0), (double)e2.get(), (double)1.0E-6);
        }
    }

    @Test
    public void testCopy() {
        Vector copy = this.test.clone();
        for (int i = 0; i < this.test.size(); ++i) {
            AbstractTestVector.assertEquals((String)("copy [" + i + ']'), (double)this.test.get(i), (double)copy.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testGet() {
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)values[i / 2], (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testGetOver() {
        this.test.get(this.test.size());
    }

    @Test(expected=IndexException.class)
    public void testGetUnder() {
        this.test.get(-1);
    }

    @Test
    public void testSet() {
        this.test.set(3, 4.5);
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            if (i == 3) {
                AbstractTestVector.assertEquals((String)("set [" + i + ']'), (double)4.5, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("set [" + i + ']'), (double)values[i / 2], (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testSize() {
        AbstractTestVector.assertEquals((String)"size", (long)3L, (long)this.test.getNumNondefaultElements());
    }

    @Test
    public void testViewPart() {
        Vector part = this.test.viewPart(1, 2);
        AbstractTestVector.assertEquals((String)"part size", (long)2L, (long)part.getNumNondefaultElements());
        for (int i = 0; i < part.size(); ++i) {
            AbstractTestVector.assertEquals((String)("part[" + i + ']'), (double)this.test.get(i + 1), (double)part.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartUnder() {
        this.test.viewPart(-1, values.length);
    }

    @Test(expected=IndexException.class)
    public void testViewPartOver() {
        this.test.viewPart(2, 7);
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        this.test.viewPart(1, 8);
    }

    @Test
    public void testSparseDoubleVectorInt() {
        RandomAccessSparseVector val = new RandomAccessSparseVector(4);
        AbstractTestVector.assertEquals((String)"size", (long)4L, (long)val.size());
        for (int i = 0; i < 4; ++i) {
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDot() {
        double res = this.test.dot(this.test);
        double expected = 16.94;
        AbstractTestVector.assertEquals((String)"dot", (double)expected, (double)res, (double)1.0E-6);
    }

    @Test
    public void testDot2() {
        Vector test2 = this.test.clone();
        test2.set(1, 0.0);
        test2.set(3, 0.0);
        AbstractTestVector.assertEquals((double)10.889999999999999, (double)test2.dot(this.test), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testDotCardinality() {
        this.test.dot((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testNormalize() {
        Vector val = this.test.normalize();
        double mag = Math.sqrt(16.939999999999998);
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)"dot", (double)(values[i / 2] / mag), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testMinus() {
        int i;
        int i2;
        Vector val = this.test.minus(this.test);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (i2 = 0; i2 < this.test.size(); ++i2) {
            AbstractTestVector.assertEquals((String)("get [" + i2 + ']'), (double)0.0, (double)val.get(i2), (double)1.0E-6);
        }
        val = this.test.minus(this.test).minus(this.test);
        AbstractTestVector.assertEquals((String)"cardinality", (long)this.test.size(), (long)val.size());
        for (i2 = 0; i2 < this.test.size(); ++i2) {
            AbstractTestVector.assertEquals((String)("get [" + i2 + ']'), (double)0.0, (double)(val.get(i2) + this.test.get(i2)), (double)1.0E-6);
        }
        Vector val1 = this.test.plus(1.0);
        val = val1.minus(this.test);
        for (i = 0; i < this.test.size(); ++i) {
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)1.0, (double)val.get(i), (double)1.0E-6);
        }
        val1 = this.test.plus(-1.0);
        val = val1.minus(this.test);
        for (i = 0; i < this.test.size(); ++i) {
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)-1.0, (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusDouble() {
        Vector val = this.test.plus(1.0);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)1.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] + 1.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusVector() {
        Vector val = this.test.plus(this.test);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * 2.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusVectorCardinality() {
        this.test.plus((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testTimesDouble() {
        Vector val = this.test.times(3.0);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDivideDouble() {
        Vector val = this.test.divide(3.0);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] / 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testTimesVector() {
        Vector val = this.test.times(this.test);
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * values[i / 2]), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testTimesVectorCardinality() {
        this.test.times((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testZSum() {
        double expected = 0.0;
        for (double value : values) {
            expected += value;
        }
        AbstractTestVector.assertEquals((String)"wrong zSum", (double)expected, (double)this.test.zSum(), (double)1.0E-6);
    }

    @Test
    public void testGetDistanceSquared() {
        RandomAccessSparseVector other = new RandomAccessSparseVector(this.test.size());
        other.set(1, -2.0);
        other.set(2, -5.0);
        other.set(3, -9.0);
        other.set(4, 1.0);
        double expected = this.test.minus((Vector)other).getLengthSquared();
        AbstractTestVector.assertTrue((String)"a.getDistanceSquared(b) != a.minus(b).getLengthSquared", (Math.abs(expected - this.test.getDistanceSquared((Vector)other)) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testAssignDouble() {
        this.test.assign(0.0);
        for (int i = 0; i < values.length; ++i) {
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignDoubleArray() {
        double[] array = new double[this.test.size()];
        this.test.assign(array);
        for (int i = 0; i < values.length; ++i) {
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayCardinality() {
        double[] array = new double[this.test.size() + 1];
        this.test.assign(array);
    }

    @Test
    public void testAssignVector() {
        DenseVector other = new DenseVector(this.test.size());
        this.test.assign((Vector)other);
        for (int i = 0; i < values.length; ++i) {
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignVectorCardinality() {
        DenseVector other = new DenseVector(this.test.size() - 1);
        this.test.assign((Vector)other);
    }

    @Test
    public void testAssignUnaryFunction() {
        this.test.assign(Functions.NEGATE);
        for (int i = 1; i < values.length; i += 2) {
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)(-values[i]), (double)this.test.getQuick(i + 2), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction() {
        this.test.assign(this.test, Functions.PLUS);
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)(2.0 * values[i - 1]), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction2() {
        this.test.assign(Functions.plus((double)4.0));
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)4.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)(values[i - 1] + 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction3() {
        this.test.assign(Functions.mult((double)4.0));
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractTestVector.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractTestVector.assertEquals((String)("value[" + i + ']'), (double)(values[i - 1] * 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testLike() {
        Vector other = this.test.like();
        AbstractTestVector.assertTrue((String)"not like", (boolean)this.test.getClass().isAssignableFrom(other.getClass()));
        AbstractTestVector.assertEquals((String)"size", (long)this.test.size(), (long)other.size());
    }

    @Test
    public void testCrossProduct() {
        Matrix result = this.test.cross(this.test);
        AbstractTestVector.assertEquals((String)"row size", (long)this.test.size(), (long)result.rowSize());
        AbstractTestVector.assertEquals((String)"col size", (long)this.test.size(), (long)result.columnSize());
        for (int row = 0; row < result.rowSize(); ++row) {
            for (int col = 0; col < result.columnSize(); ++col) {
                AbstractTestVector.assertEquals((String)("cross[" + row + "][" + col + ']'), (double)(this.test.getQuick(row) * this.test.getQuick(col)), (double)result.getQuick(row, col), (double)1.0E-6);
            }
        }
    }
}

