/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.junit.Test;

public final class RandomUtilsTest
extends MahoutTestCase {
    @Test
    public void testHashDouble() {
        RandomUtilsTest.assertEquals((long)new Double(0.0).hashCode(), (long)RandomUtils.hashDouble((double)0.0));
        RandomUtilsTest.assertEquals((long)new Double(1.0).hashCode(), (long)RandomUtils.hashDouble((double)1.0));
        RandomUtilsTest.assertEquals((long)new Double(Double.POSITIVE_INFINITY).hashCode(), (long)RandomUtils.hashDouble((double)Double.POSITIVE_INFINITY));
        RandomUtilsTest.assertEquals((long)new Double(Double.NaN).hashCode(), (long)RandomUtils.hashDouble((double)Double.NaN));
    }

    @Test
    public void testHashFloat() {
        RandomUtilsTest.assertEquals((long)new Float(0.0f).hashCode(), (long)RandomUtils.hashFloat((float)0.0f));
        RandomUtilsTest.assertEquals((long)new Float(1.0f).hashCode(), (long)RandomUtils.hashFloat((float)1.0f));
        RandomUtilsTest.assertEquals((long)new Float(Float.POSITIVE_INFINITY).hashCode(), (long)RandomUtils.hashFloat((float)Float.POSITIVE_INFINITY));
        RandomUtilsTest.assertEquals((long)new Float(Float.NaN).hashCode(), (long)RandomUtils.hashFloat((float)Float.NaN));
    }

    @Test
    public void testIsNotPrime() {
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)Integer.MIN_VALUE));
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)-1));
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)0));
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)1));
        RandomUtilsTest.assertTrue((!RandomUtils.isNotPrime((int)2) ? 1 : 0) != 0);
        RandomUtilsTest.assertTrue((!RandomUtils.isNotPrime((int)3) ? 1 : 0) != 0);
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)4));
        RandomUtilsTest.assertTrue((!RandomUtils.isNotPrime((int)5) ? 1 : 0) != 0);
        RandomUtilsTest.assertTrue((boolean)RandomUtils.isNotPrime((int)0x7FFFFFFE));
        RandomUtilsTest.assertTrue((!RandomUtils.isNotPrime((int)Integer.MAX_VALUE) ? 1 : 0) != 0);
    }

    @Test
    public void testNextPrime() {
        RandomUtilsTest.assertEquals((long)2L, (long)RandomUtils.nextPrime((int)-1));
        RandomUtilsTest.assertEquals((long)2L, (long)RandomUtils.nextPrime((int)1));
        RandomUtilsTest.assertEquals((long)2L, (long)RandomUtils.nextPrime((int)2));
        RandomUtilsTest.assertEquals((long)3L, (long)RandomUtils.nextPrime((int)3));
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextPrime((int)4));
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextPrime((int)5));
        RandomUtilsTest.assertEquals((long)7L, (long)RandomUtils.nextPrime((int)6));
        RandomUtilsTest.assertEquals((long)Integer.MAX_VALUE, (long)RandomUtils.nextPrime((int)0x7FFFFFFE));
    }

    @Test
    public void testNextTwinPrime() {
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextTwinPrime((int)-1));
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextTwinPrime((int)1));
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextTwinPrime((int)2));
        RandomUtilsTest.assertEquals((long)5L, (long)RandomUtils.nextTwinPrime((int)3));
        RandomUtilsTest.assertEquals((long)7L, (long)RandomUtils.nextTwinPrime((int)4));
        RandomUtilsTest.assertEquals((long)7L, (long)RandomUtils.nextTwinPrime((int)5));
        RandomUtilsTest.assertEquals((long)13L, (long)RandomUtils.nextTwinPrime((int)6));
        RandomUtilsTest.assertEquals((long)2147482951L, (long)RandomUtils.nextTwinPrime((int)2147482949));
        try {
            RandomUtils.nextTwinPrime((int)2147482950);
            RandomUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLongToSeed() {
        Random r = RandomUtils.getRandom();
        for (int i = 0; i < 10000; ++i) {
            long l = r.nextLong();
            byte[] bytes = RandomUtils.longSeedtoBytes((long)l);
            long back = RandomUtils.seedBytesToLong((byte[])bytes);
            RandomUtilsTest.assertEquals((long)l, (long)back);
        }
    }

    @Test
    public void testSetSeed() {
        Random rTest0 = RandomUtils.getRandom();
        Random rTest1 = RandomUtils.getRandom();
        Random r0 = RandomUtils.getRandom((long)0L);
        Random r1 = RandomUtils.getRandom((long)1L);
        long lTest0 = rTest0.nextLong();
        long lTest1 = rTest1.nextLong();
        long l0 = r0.nextLong();
        long l1 = r1.nextLong();
        RandomUtilsTest.assertEquals((String)"getRandom() must match getRandom() in unit tests", (long)lTest0, (long)lTest1);
        RandomUtilsTest.assertTrue((String)"getRandom() must differ from getRandom(0)", (lTest0 != l1 ? 1 : 0) != 0);
        RandomUtilsTest.assertTrue((String)"getRandom(0) must differ from getRandom(1)", (l0 != l1 ? 1 : 0) != 0);
    }
}

