/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.solver;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.solver.LSMR;
import org.junit.Test;

public final class LSMRTest
extends MahoutTestCase {
    @Test
    public void basics() {
        Matrix m = LSMRTest.hilbert(5);
        LSMRTest.assertEquals((double)1.0, (double)m.get(0, 0), (double)0.0);
        LSMRTest.assertEquals((double)0.5, (double)m.get(0, 1), (double)0.0);
        LSMRTest.assertEquals((double)0.16666666666666666, (double)m.get(2, 3), (double)1.0E-9);
        DenseVector x = new DenseVector(new double[]{5.0, -120.0, 630.0, -1120.0, 630.0});
        DenseVector b = new DenseVector(5);
        b.assign(1.0);
        LSMRTest.assertEquals((double)0.0, (double)m.times((Vector)x).minus((Vector)b).norm(2.0), (double)1.0E-9);
        LSMR r = new LSMR();
        Vector x1 = r.solve(m, (Vector)b);
        LSMRTest.assertEquals((double)0.0, (double)m.times(x1).minus((Vector)b).norm(2.0), (double)0.01);
        LSMRTest.assertEquals((double)0.0, (double)m.transpose().times(m).times(x1).minus(m.transpose().times((Vector)b)).norm(2.0), (double)1.0E-7);
        LSMRTest.assertEquals((double)m.times(x1).minus((Vector)b).norm(2.0), (double)r.getResidualNorm(), (double)1.0E-5);
        LSMRTest.assertEquals((double)m.transpose().times(m).times(x1).minus(m.transpose().times((Vector)b)).norm(2.0), (double)r.getNormalEquationResidual(), (double)1.0E-9);
    }

    @Test
    public void random() {
        Matrix m = new DenseMatrix(200, 30).assign(Functions.random());
        Vector b = new DenseVector(200).assign(1.0);
        LSMR r = new LSMR();
        Vector x1 = r.solve(m, b);
        double norm = new SingularValueDecomposition(m).getS().viewDiagonal().norm(2.0);
        double actual = m.transpose().times(m).times(x1).minus(m.transpose().times(b)).norm(2.0);
        System.out.printf("%.4f\n", actual / norm * 1000000.0);
        LSMRTest.assertEquals((double)0.0, (double)actual, (double)(norm * 1.0E-5));
        LSMRTest.assertEquals((double)m.times(x1).minus(b).norm(2.0), (double)r.getResidualNorm(), (double)1.0E-5);
        LSMRTest.assertEquals((double)actual, (double)r.getNormalEquationResidual(), (double)1.0E-9);
    }

    private static Matrix hilbert(int n) {
        DenseMatrix r = new DenseMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                r.set(i, j, 1.0 / (double)(i + j + 1));
            }
        }
        return r;
    }
}

