/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongIntProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        OpenLongIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongIntHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        OpenLongIntHashMap map2 = (OpenLongIntHashMap)map.clone();
        map.clear();
        OpenLongIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        OpenLongIntHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongIntHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        OpenLongIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenLongIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongIntHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        map.forEachPair(new LongIntProcedure(){

            public boolean apply(long first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenLongIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenLongIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new LongIntProcedure(){
            int count = 0;

            public boolean apply(long first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        OpenLongIntHashMapTest.assertEquals((long)22L, (long)map.get(11L));
        OpenLongIntHashMapTest.assertEquals((long)0L, (long)map.get(0L));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.adjustOrPutValue(11L, 1, 3);
        OpenLongIntHashMapTest.assertEquals((long)25L, (long)map.get(11L));
        map.adjustOrPutValue(15L, 1, 3);
        OpenLongIntHashMapTest.assertEquals((long)1L, (long)map.get(15L));
    }

    @Test
    public void testKeys() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 22);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        map.pairsMatching(new LongIntProcedure(){

            public boolean apply(long first, int second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongIntHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongIntHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenLongIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenLongIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenLongIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenLongIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        OpenLongIntHashMap map2 = (OpenLongIntHashMap)map.copy();
        map.clear();
        OpenLongIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        OpenLongIntHashMap map2 = (OpenLongIntHashMap)map.copy();
        OpenLongIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 22);
        map.put(12L, 23);
        map.put(13L, 24);
        map.put(14L, 25);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongIntHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        map.put(11L, 100);
        map.put(12L, 70);
        map.put(13L, 30);
        map.put(14L, 3);
        LongArrayList keys = new LongArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenLongIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenLongIntHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenLongIntHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongIntHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenLongIntHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenLongIntHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenLongIntHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        int v;

        Pair(long k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

