/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatCharProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenFloatCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        OpenFloatCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatCharHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        OpenFloatCharHashMap map2 = (OpenFloatCharHashMap)map.clone();
        map.clear();
        OpenFloatCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        OpenFloatCharHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatCharHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        OpenFloatCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenFloatCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatCharHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        map.forEachPair(new FloatCharProcedure(){

            public boolean apply(float first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatCharHashMapTest.assertEquals((float)11.0f, (float)((Pair)pairs.get((int)0)).k, (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenFloatCharHashMapTest.assertEquals((float)12.0f, (float)((Pair)pairs.get((int)1)).k, (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenFloatCharHashMapTest.assertEquals((float)14.0f, (float)((Pair)pairs.get((int)2)).k, (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new FloatCharProcedure(){
            int count = 0;

            public boolean apply(float first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        OpenFloatCharHashMapTest.assertEquals((long)22L, (long)map.get(11.0f));
        OpenFloatCharHashMapTest.assertEquals((long)0L, (long)map.get(0.0f));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.adjustOrPutValue(11.0f, '\u0001', '\u0003');
        OpenFloatCharHashMapTest.assertEquals((long)25L, (long)map.get(11.0f));
        map.adjustOrPutValue(15.0f, '\u0001', '\u0003');
        OpenFloatCharHashMapTest.assertEquals((long)1L, (long)map.get(15.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0016');
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatCharHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        map.pairsMatching(new FloatCharProcedure(){

            public boolean apply(float first, char second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatCharHashMapTest.assertEquals((float)12.0f, (float)keyList.get(0), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((float)14.0f, (float)keyList.get(1), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenFloatCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenFloatCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenFloatCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenFloatCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        OpenFloatCharHashMap map2 = (OpenFloatCharHashMap)map.copy();
        map.clear();
        OpenFloatCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        OpenFloatCharHashMap map2 = (OpenFloatCharHashMap)map.copy();
        OpenFloatCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, '\u0016');
        map.put(12.0f, '\u0017');
        map.put(13.0f, '\u0018');
        map.put(14.0f, '\u0019');
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatCharHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatCharHashMap map = new OpenFloatCharHashMap();
        map.put(11.0f, 'd');
        map.put(12.0f, 'F');
        map.put(13.0f, '\u001e');
        map.put(14.0f, '\u0003');
        FloatArrayList keys = new FloatArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatCharHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenFloatCharHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenFloatCharHashMapTest.assertEquals((float)13.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenFloatCharHashMapTest.assertEquals((float)14.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatCharHashMapTest.assertEquals((float)11.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenFloatCharHashMapTest.assertEquals((float)12.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenFloatCharHashMapTest.assertEquals((float)13.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenFloatCharHashMapTest.assertEquals((float)14.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        char v;

        Pair(float k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

