/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleByteProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenDoubleByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        OpenDoubleByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleByteHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        OpenDoubleByteHashMap map2 = (OpenDoubleByteHashMap)map.clone();
        map.clear();
        OpenDoubleByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        OpenDoubleByteHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleByteHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        OpenDoubleByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenDoubleByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleByteHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        map.forEachPair(new DoubleByteProcedure(){

            public boolean apply(double first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleByteHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenDoubleByteHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenDoubleByteHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new DoubleByteProcedure(){
            int count = 0;

            public boolean apply(double first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        OpenDoubleByteHashMapTest.assertEquals((long)22L, (long)map.get(11.0));
        OpenDoubleByteHashMapTest.assertEquals((long)0L, (long)map.get(0.0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.adjustOrPutValue(11.0, (byte)1, (byte)3);
        OpenDoubleByteHashMapTest.assertEquals((long)25L, (long)map.get(11.0));
        map.adjustOrPutValue(15.0, (byte)1, (byte)3);
        OpenDoubleByteHashMapTest.assertEquals((long)1L, (long)map.get(15.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)22);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleByteHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleByteProcedure(){

            public boolean apply(double first, byte second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleByteHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenDoubleByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenDoubleByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenDoubleByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenDoubleByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        OpenDoubleByteHashMap map2 = (OpenDoubleByteHashMap)map.copy();
        map.clear();
        OpenDoubleByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        OpenDoubleByteHashMap map2 = (OpenDoubleByteHashMap)map.copy();
        OpenDoubleByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)22);
        map.put(12.0, (byte)23);
        map.put(13.0, (byte)24);
        map.put(14.0, (byte)25);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleByteHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleByteHashMap map = new OpenDoubleByteHashMap();
        map.put(11.0, (byte)100);
        map.put(12.0, (byte)70);
        map.put(13.0, (byte)30);
        map.put(14.0, (byte)3);
        DoubleArrayList keys = new DoubleArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleByteHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenDoubleByteHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenDoubleByteHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenDoubleByteHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleByteHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenDoubleByteHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenDoubleByteHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenDoubleByteHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        byte v;

        Pair(double k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

