/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharByteProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.OpenCharByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        OpenCharByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharByteHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        OpenCharByteHashMap map2 = (OpenCharByteHashMap)map.clone();
        map.clear();
        OpenCharByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        OpenCharByteHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharByteHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        OpenCharByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenCharByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharByteHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        map.forEachPair(new CharByteProcedure(){

            public boolean apply(char first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenCharByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenCharByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new CharByteProcedure(){
            int count = 0;

            public boolean apply(char first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        OpenCharByteHashMapTest.assertEquals((long)22L, (long)map.get('\u000b'));
        OpenCharByteHashMapTest.assertEquals((long)0L, (long)map.get('\u0000'));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.adjustOrPutValue('\u000b', (byte)1, (byte)3);
        OpenCharByteHashMapTest.assertEquals((long)25L, (long)map.get('\u000b'));
        map.adjustOrPutValue('\u000f', (byte)1, (byte)3);
        OpenCharByteHashMapTest.assertEquals((long)1L, (long)map.get('\u000f'));
    }

    @Test
    public void testKeys() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)22);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        map.pairsMatching(new CharByteProcedure(){

            public boolean apply(char first, byte second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharByteHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharByteHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenCharByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenCharByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenCharByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenCharByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        OpenCharByteHashMap map2 = (OpenCharByteHashMap)map.copy();
        map.clear();
        OpenCharByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        OpenCharByteHashMap map2 = (OpenCharByteHashMap)map.copy();
        OpenCharByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)22);
        map.put('\f', (byte)23);
        map.put('\r', (byte)24);
        map.put('\u000e', (byte)25);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharByteHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharByteHashMap map = new OpenCharByteHashMap();
        map.put('\u000b', (byte)100);
        map.put('\f', (byte)70);
        map.put('\r', (byte)30);
        map.put('\u000e', (byte)3);
        CharArrayList keys = new CharArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenCharByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenCharByteHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenCharByteHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharByteHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenCharByteHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenCharByteHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenCharByteHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        byte v;

        Pair(char k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

