/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteDoubleProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenByteDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        OpenByteDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteDoubleHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        OpenByteDoubleHashMap map2 = (OpenByteDoubleHashMap)map.clone();
        map.clear();
        OpenByteDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        OpenByteDoubleHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteDoubleHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        OpenByteDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenByteDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteDoubleHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        map.forEachPair(new ByteDoubleProcedure(){

            public boolean apply(byte first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteDoubleHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new ByteDoubleProcedure(){
            int count = 0;

            public boolean apply(byte first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        OpenByteDoubleHashMapTest.assertEquals((double)22.0, (double)map.get((byte)11), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((double)0.0, (double)map.get((byte)0), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.adjustOrPutValue((byte)11, 1.0, 3.0);
        OpenByteDoubleHashMapTest.assertEquals((double)25.0, (double)map.get((byte)11), (double)1.0E-6);
        map.adjustOrPutValue((byte)15, 1.0, 3.0);
        OpenByteDoubleHashMapTest.assertEquals((double)1.0, (double)map.get((byte)15), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 22.0);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        map.pairsMatching(new ByteDoubleProcedure(){

            public boolean apply(byte first, double second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteDoubleHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteDoubleHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenByteDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        OpenByteDoubleHashMap map2 = (OpenByteDoubleHashMap)map.copy();
        map.clear();
        OpenByteDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        OpenByteDoubleHashMap map2 = (OpenByteDoubleHashMap)map.copy();
        OpenByteDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 22.0);
        map.put((byte)12, 23.0);
        map.put((byte)13, 24.0);
        map.put((byte)14, 25.0);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteDoubleHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteDoubleHashMap map = new OpenByteDoubleHashMap();
        map.put((byte)11, 100.0);
        map.put((byte)12, 70.0);
        map.put((byte)13, 30.0);
        map.put((byte)14, 3.0);
        ByteArrayList keys = new ByteArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenByteDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        double v;

        Pair(byte k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

