/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.AbstractDoubleList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleArrayListTest
extends Assert {
    private DoubleArrayList emptyList;
    private DoubleArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new DoubleArrayList();
        this.listOfFive = new DoubleArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((double)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, 1.0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, 0.0);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add(12.0);
        DoubleArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((double)x % Double.MAX_VALUE);
        }
        DoubleArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        DoubleArrayListTest.assertEquals((double)12.0, (double)this.emptyList.get(0), (double)1.0);
        for (x = 0; x < 1000; ++x) {
            DoubleArrayListTest.assertEquals((double)((double)x % Double.MAX_VALUE), (double)this.emptyList.get(x + 1), (double)1.0);
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo(0.0, 2, 4);
        DoubleArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo(1.0, 0, 4);
        DoubleArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        DoubleArrayList l2 = this.listOfFive.copy();
        DoubleArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        DoubleArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        double[] l = new double[]{12.0, 24.0, 36.0, 48.0};
        DoubleArrayList lar = new DoubleArrayList(l);
        DoubleArrayListTest.assertEquals((long)4L, (long)lar.size());
        DoubleArrayListTest.assertSame((Object)l, (Object)lar.elements());
        double[] l2 = new double[]{3.0, 6.0, 9.0, 12.0};
        lar.elements(l2);
        DoubleArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        double[] l = new double[]{12.0, 24.0, 36.0, 48.0};
        DoubleArrayList lar = new DoubleArrayList(l);
        DoubleArrayList lar2 = new DoubleArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        DoubleArrayListTest.assertEquals((Object)lar, (Object)lar2);
        DoubleArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add(55.0);
        DoubleArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new DoubleProcedure(){
            int count;

            public boolean apply(double element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1.0;
            }
        });
    }

    @Test
    public void testGetQuick() {
        DoubleArrayList lar = new DoubleArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo(0.0, 2, 4);
        DoubleArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo(1.0, 0, 4);
        DoubleArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        DoubleArrayList lar = new DoubleArrayList(10);
        lar.add(1.0);
        lar.add(2.0);
        lar.add(3.0);
        lar.add(2.0);
        lar.add(1.0);
        DoubleArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf(2.0));
        DoubleArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo(2.0, 2, 4));
        DoubleArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf(111.0));
    }

    @Test
    public void testPartFromTo() {
        AbstractDoubleList al = this.listOfFive.partFromTo(1, 2);
        DoubleArrayListTest.assertEquals((long)2L, (long)al.size());
        DoubleArrayListTest.assertEquals((double)1.0, (double)al.get(0), (double)1.0);
        DoubleArrayListTest.assertEquals((double)2.0, (double)al.get(1), (double)1.0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        DoubleArrayList lar = new DoubleArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((double)x2);
        }
        DoubleArrayList larOdd = new DoubleArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((double)x);
        }
        lar.removeAll((AbstractDoubleList)larOdd);
        DoubleArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            DoubleArrayListTest.assertEquals((double)(x * 2), (double)lar.get(x), (double)1.0);
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add(5.0);
        DoubleArrayList lar = new DoubleArrayList();
        lar.add(44.0);
        lar.add(55.0);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractDoubleList)lar, 0, 1);
        DoubleArrayListTest.assertEquals((double)0.0, (double)this.listOfFive.get(0), (double)1.0);
        DoubleArrayListTest.assertEquals((double)1.0, (double)this.listOfFive.get(1), (double)1.0);
        DoubleArrayListTest.assertEquals((double)44.0, (double)this.listOfFive.get(2), (double)1.0);
        DoubleArrayListTest.assertEquals((double)55.0, (double)this.listOfFive.get(3), (double)1.0);
        DoubleArrayListTest.assertEquals((double)4.0, (double)this.listOfFive.get(4), (double)1.0);
        DoubleArrayListTest.assertEquals((double)5.0, (double)this.listOfFive.get(5), (double)1.0);
    }

    @Test
    public void testRetainAllSmall() {
        DoubleArrayList lar = new DoubleArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        DoubleArrayList lar2 = new DoubleArrayList();
        lar2.add(3.0);
        lar2.add(4.0);
        DoubleArrayListTest.assertTrue((boolean)lar.retainAll((AbstractDoubleList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            double l = lar.get(x);
            DoubleArrayListTest.assertTrue((l == 3.0 || l == 4.0 ? 1 : 0) != 0);
        }
        DoubleArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        DoubleArrayList lar = new DoubleArrayList();
        lar.addAllOf(this.listOfFive);
        DoubleArrayList lar2 = new DoubleArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add(3.0);
            lar2.add(4.0);
        }
        DoubleArrayListTest.assertTrue((boolean)lar.retainAll((AbstractDoubleList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            double l = lar.get(x);
            DoubleArrayListTest.assertTrue((l == 3.0 || l == 4.0 ? 1 : 0) != 0);
        }
    }
}

