/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Splitter;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.AbstractVectorTest;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestRandomAccessSparseVector
extends AbstractVectorTest<RandomAccessSparseVector> {
    @Override
    Vector generateTestVector(int cardinality) {
        return new RandomAccessSparseVector(cardinality);
    }

    @Override
    public RandomAccessSparseVector vectorToTest(int size) {
        RandomAccessSparseVector r = new RandomAccessSparseVector(size);
        RandomWrapper gen = RandomUtils.getRandom();
        for (int i = 0; i < 3; ++i) {
            r.set(gen.nextInt(r.size()), gen.nextGaussian());
        }
        return r;
    }

    @Override
    @Test
    public void testToString() {
        Vector w = this.generateTestVector(20);
        w.set(0, 1.1);
        w.set(13, 100500.0);
        w.set(19, 3.141592);
        for (String token : Splitter.on((char)',').split((CharSequence)w.toString().substring(1, w.toString().length() - 1))) {
            String[] tokens = token.split(":");
            TestRandomAccessSparseVector.assertEquals((double)Double.parseDouble(tokens[1]), (double)w.get(Integer.parseInt(tokens[0])), (double)0.0);
        }
        w = this.generateTestVector(12);
        w.set(10, 0.1);
        TestRandomAccessSparseVector.assertEquals((Object)"{10:0.1}", (Object)w.toString());
        w = this.generateTestVector(12);
        TestRandomAccessSparseVector.assertEquals((Object)"{}", (Object)w.toString());
    }
}

