/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseColumnMatrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.VectorFunction;
import org.junit.Before;
import org.junit.Test;

public abstract class MatrixTest
extends MahoutTestCase {
    protected static final int ROW = 0;
    protected static final int COL = 1;
    private final double[][] values = new double[][]{{1.1, 2.2}, {3.3, 4.4}, {5.5, 6.6}};
    private final double[] vectorAValues = new double[]{0.9090909090909091, 1.8181818181818181};
    private Matrix test;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.test = this.matrixFactory(this.values);
    }

    public abstract Matrix matrixFactory(double[][] var1);

    @Test
    public void testCardinality() {
        MatrixTest.assertEquals((String)"row cardinality", (long)this.values.length, (long)this.test.rowSize());
        MatrixTest.assertEquals((String)"col cardinality", (long)this.values[0].length, (long)this.test.columnSize());
    }

    @Test
    public void testCopy() {
        Matrix copy = this.test.clone();
        MatrixTest.assertSame((String)"wrong class", copy.getClass(), this.test.getClass());
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)copy.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testClone() {
        double oldValue = 1.23;
        double newValue = 2.34;
        double[][] values = new double[][]{{oldValue, 3.0}, {3.0, 5.0}, {7.0, 9.0}};
        Matrix matrix = this.matrixFactory(values);
        Matrix clone = matrix.clone();
        clone.set(0, 0, newValue);
        MatrixTest.assertEquals((String)"Matrix clone is not independent of the original", (double)oldValue, (double)matrix.get(0, 0), (double)1.0E-6);
    }

    @Test
    public void testIterate() {
        MatrixSlice m;
        Iterator it = this.test.iterator();
        while (it.hasNext() && (m = (MatrixSlice)it.next()) != null) {
            Vector v = m.vector();
            Vector w = this.test instanceof SparseColumnMatrix ? this.test.viewColumn(m.index()) : this.test.viewRow(m.index());
            MatrixTest.assertEquals((String)("iterator: " + v + ", randomAccess: " + w), (Object)v, (Object)w);
        }
    }

    @Test
    public void testGetQuick() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row][col], (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testLike() {
        Matrix like = this.test.like();
        MatrixTest.assertSame((String)"type", like.getClass(), this.test.getClass());
        MatrixTest.assertEquals((String)"rows", (long)this.test.rowSize(), (long)like.rowSize());
        MatrixTest.assertEquals((String)"columns", (long)this.test.columnSize(), (long)like.columnSize());
    }

    @Test
    public void testLikeIntInt() {
        Matrix like = this.test.like(4, 4);
        MatrixTest.assertSame((String)"type", like.getClass(), this.test.getClass());
        MatrixTest.assertEquals((String)"rows", (long)4L, (long)like.rowSize());
        MatrixTest.assertEquals((String)"columns", (long)4L, (long)like.columnSize());
    }

    @Test
    public void testSetQuick() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.setQuick(row, col, 1.23);
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)1.23, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSize() {
        int[] c = this.test.getNumNondefaultElements();
        MatrixTest.assertEquals((String)"row size", (long)this.values.length, (long)c[0]);
        MatrixTest.assertEquals((String)"col size", (long)this.values[0].length, (long)c[1]);
    }

    @Test
    public void testViewPart() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 1};
        Matrix view = this.test.viewPart(offset, size);
        MatrixTest.assertEquals((long)2L, (long)view.rowSize());
        MatrixTest.assertEquals((long)1L, (long)view.columnSize());
        for (int row = 0; row < view.rowSize(); ++row) {
            for (int col = 0; col < view.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row + 1][col + 1], (double)view.get(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{3, 3};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexOver() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexUnder() {
        int[] offset = new int[]{-1, -1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test
    public void testAssignDouble() {
        this.test.assign(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)4.53, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testAssignDoubleArrayArray() {
        this.test.assign(new double[3][2]);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayArrayCardinality() {
        this.test.assign(new double[this.test.rowSize() + 1][this.test.columnSize()]);
    }

    @Test
    public void testMatrixViewBug() {
        Matrix m = this.test.viewPart(0, 3, 0, 2);
        m = m.viewPart(2, 1, 0, 1);
        MatrixTest.assertEquals((double)5.5, (double)m.zSum(), (double)0.0);
    }

    @Test
    public void testAssignMatrixBinaryFunction() {
        this.test.assign(this.test, Functions.PLUS);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(2.0 * this.values[row][col]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixBinaryFunctionCardinality() {
        this.test.assign(this.test.transpose(), Functions.PLUS);
    }

    @Test
    public void testAssignMatrix() {
        Matrix value = this.test.like();
        value.assign(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixCardinality() {
        this.test.assign(this.test.transpose());
    }

    @Test
    public void testAssignUnaryFunction() {
        this.test.assign(Functions.mult((double)-1.0));
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(-this.values[row][col]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testRowView() {
        MatrixTest.assertEquals((long)this.test.columnSize(), (long)this.test.viewRow(1).size());
        MatrixTest.assertEquals((long)this.test.columnSize(), (long)this.test.viewRow(2).size());
        RandomWrapper gen = RandomUtils.getRandom();
        for (int row = 0; row < this.test.rowSize(); ++row) {
            int j = gen.nextInt(this.test.columnSize());
            double old = this.test.get(row, j);
            double v = gen.nextGaussian();
            this.test.viewRow(row).set(j, v);
            MatrixTest.assertEquals((double)v, (double)this.test.get(row, j), (double)0.0);
            MatrixTest.assertEquals((double)v, (double)this.test.viewRow(row).get(j), (double)0.0);
            this.test.set(row, j, old);
            MatrixTest.assertEquals((double)old, (double)this.test.get(row, j), (double)0.0);
            MatrixTest.assertEquals((double)old, (double)this.test.viewRow(row).get(j), (double)0.0);
        }
    }

    @Test
    public void testColumnView() {
        MatrixTest.assertEquals((long)this.test.rowSize(), (long)this.test.viewColumn(0).size());
        MatrixTest.assertEquals((long)this.test.rowSize(), (long)this.test.viewColumn(1).size());
        RandomWrapper gen = RandomUtils.getRandom();
        for (int col = 0; col < this.test.columnSize(); ++col) {
            int j = gen.nextInt(this.test.columnSize());
            double old = this.test.get(col, j);
            double v = gen.nextGaussian();
            this.test.viewColumn(col).set(j, v);
            MatrixTest.assertEquals((double)v, (double)this.test.get(j, col), (double)0.0);
            MatrixTest.assertEquals((double)v, (double)this.test.viewColumn(col).get(j), (double)0.0);
            this.test.set(j, col, old);
            MatrixTest.assertEquals((double)old, (double)this.test.get(j, col), (double)0.0);
            MatrixTest.assertEquals((double)old, (double)this.test.viewColumn(col).get(j), (double)0.0);
        }
    }

    @Test
    public void testAggregateRows() {
        Vector v = this.test.aggregateRows(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        });
        for (int i = 0; i < this.test.numRows(); ++i) {
            MatrixTest.assertEquals((double)this.test.viewRow(i).zSum(), (double)v.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAggregateCols() {
        Vector v = this.test.aggregateColumns(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        });
        for (int i = 0; i < this.test.numCols(); ++i) {
            MatrixTest.assertEquals((double)this.test.viewColumn(i).zSum(), (double)v.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAggregate() {
        double total = this.test.aggregate(Functions.PLUS, Functions.IDENTITY);
        MatrixTest.assertEquals((double)this.test.aggregateRows(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        }).zSum(), (double)total, (double)1.0E-6);
    }

    @Test
    public void testDivide() {
        Matrix value = this.test.divide(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] / 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testGet() {
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row][col], (double)this.test.get(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexUnder() {
        for (int row = -1; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexOver() {
        for (int row = 0; row < this.test.rowSize() + 1; ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test
    public void testMinus() {
        Matrix value = this.test.minus(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testMinusCardinality() {
        this.test.minus(this.test.transpose());
    }

    @Test
    public void testPlusDouble() {
        Matrix value = this.test.plus(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] + 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testPlusMatrix() {
        Matrix value = this.test.plus(this.test);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] * 2.0), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusMatrixCardinality() {
        this.test.plus(this.test.transpose());
    }

    @Test(expected=IndexException.class)
    public void testSetUnder() {
        for (int row = -1; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testSetOver() {
        for (int row = 0; row < this.test.rowSize() + 1; ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test
    public void testTimesDouble() {
        Matrix value = this.test.times(4.53);
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] * 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testTimesMatrix() {
        Matrix transpose = this.test.transpose();
        Matrix value = this.test.times(transpose);
        MatrixTest.assertEquals((String)"rows", (long)this.test.rowSize(), (long)value.rowSize());
        MatrixTest.assertEquals((String)"cols", (long)this.test.rowSize(), (long)value.columnSize());
        Matrix expected = new DenseMatrix((double[][])new double[][]{{5.0, 11.0, 17.0}, {11.0, 25.0, 39.0}, {17.0, 39.0, 61.0}}).times(1.21);
        for (int i = 0; i < expected.numCols(); ++i) {
            for (int j = 0; j < expected.numRows(); ++j) {
                MatrixTest.assertTrue((String)("Matrix times transpose not correct: " + i + ", " + j + "\nexpected:\n\t" + expected + "\nactual:\n\t" + value), (Math.abs(expected.get(i, j) - value.get(i, j)) < 1.0E-12 ? 1 : 0) != 0);
            }
        }
        DenseMatrix timestest = new DenseMatrix(10, 1);
        timestest.transpose().times((Matrix)timestest);
    }

    @Test(expected=CardinalityException.class)
    public void testTimesVector() {
        DenseVector vectorA = new DenseVector(this.vectorAValues);
        Vector testTimesVectorA = this.test.times((Vector)vectorA);
        DenseVector expected = new DenseVector(new double[]{5.0, 11.0, 17.0});
        MatrixTest.assertTrue((String)("Matrix times vector not equals: " + vectorA + " != " + testTimesVectorA), (expected.minus(testTimesVectorA).norm(2.0) < 1.0E-12 ? 1 : 0) != 0);
        this.test.times(testTimesVectorA);
    }

    @Test
    public void testTimesSquaredTimesVector() {
        DenseVector vectorA = new DenseVector(this.vectorAValues);
        Vector ttA = this.test.timesSquared((Vector)vectorA);
        Vector ttASlow = this.test.transpose().times(this.test.times((Vector)vectorA));
        MatrixTest.assertTrue((String)("M'Mv != M.timesSquared(v): " + ttA + " != " + ttASlow), (ttASlow.minus(ttA).norm(2.0) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test(expected=CardinalityException.class)
    public void testTimesMatrixCardinality() {
        Matrix other = this.test.like(5, 8);
        this.test.times(other);
    }

    @Test
    public void testTranspose() {
        Matrix transpose = this.test.transpose();
        MatrixTest.assertEquals((String)"rows", (long)this.test.columnSize(), (long)transpose.rowSize());
        MatrixTest.assertEquals((String)"cols", (long)this.test.rowSize(), (long)transpose.columnSize());
        for (int row = 0; row < this.test.rowSize(); ++row) {
            for (int col = 0; col < this.test.columnSize(); ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)transpose.getQuick(col, row), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testZSum() {
        double sum = this.test.zSum();
        MatrixTest.assertEquals((String)"zsum", (double)23.1, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testAssignRow() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignRow(1, (Vector)new DenseVector(data));
        MatrixTest.assertEquals((String)"test[1][0]", (double)2.1, (double)this.test.getQuick(1, 0), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignRowCardinality() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignRow(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testAssignColumn() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
        MatrixTest.assertEquals((String)"test[0][1]", (double)2.1, (double)this.test.getQuick(0, 1), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[2][1]", (double)4.3, (double)this.test.getQuick(2, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignColumnCardinality() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testViewRow() {
        Vector row = this.test.viewRow(1);
        MatrixTest.assertEquals((String)"row size", (long)2L, (long)row.getNumNondefaultElements());
        SparseMatrix matrix = new SparseMatrix(1, 1);
        Vector view = matrix.viewRow(0);
        double value = 1.23;
        view.assign(1.23);
        MatrixTest.assertEquals((String)"Matrix value", (double)view.getQuick(0), (double)matrix.getQuick(0, 0), (double)1.0E-6);
    }

    @Test(expected=IndexException.class)
    public void testViewRowIndexUnder() {
        this.test.viewRow(-1);
    }

    @Test(expected=IndexException.class)
    public void testViewRowIndexOver() {
        this.test.viewRow(5);
    }

    @Test
    public void testViewColumn() {
        Vector column = this.test.viewColumn(1);
        MatrixTest.assertEquals((String)"row size", (long)3L, (long)column.getNumNondefaultElements());
    }

    @Test(expected=IndexException.class)
    public void testViewColumnIndexUnder() {
        this.test.viewColumn(-1);
    }

    @Test(expected=IndexException.class)
    public void testViewColumnIndexOver() {
        this.test.viewColumn(5);
    }

    @Test
    public void testDeterminant() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertEquals((String)"determinant", (double)43.0, (double)m.determinant(), (double)1.0E-6);
    }

    @Test
    public void testLabelBindings() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        HashMap rowBindings = Maps.newHashMap();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        rowBindings.put("Foe", 2);
        m.setRowLabelBindings((Map)rowBindings);
        MatrixTest.assertEquals((String)"row", (Object)rowBindings, (Object)m.getRowLabelBindings());
        HashMap colBindings = Maps.newHashMap();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        colBindings.put("Baz", 2);
        m.setColumnLabelBindings((Map)colBindings);
        MatrixTest.assertEquals((String)"row", (Object)rowBindings, (Object)m.getRowLabelBindings());
        MatrixTest.assertEquals((String)"Fee", (double)m.get(0, 1), (double)m.get("Fee", "Bar"), (double)1.0E-6);
        double[] newrow = new double[]{9.0, 8.0, 7.0};
        m.set("Foe", newrow);
        MatrixTest.assertEquals((String)"FeeBaz", (double)m.get(0, 2), (double)m.get("Fee", "Baz"), (double)1.0E-6);
    }

    @Test(expected=IllegalStateException.class)
    public void testSettingLabelBindings() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        m.set("Fee", "Foo", 1, 2, 9.0);
        MatrixTest.assertNotNull((String)"row", (Object)m.getRowLabelBindings());
        MatrixTest.assertNotNull((String)"row", (Object)m.getRowLabelBindings());
        MatrixTest.assertEquals((String)"Fee", (long)1L, (long)((Integer)m.getRowLabelBindings().get("Fee")).intValue());
        MatrixTest.assertEquals((String)"Fee", (long)2L, (long)((Integer)m.getColumnLabelBindings().get("Foo")).intValue());
        MatrixTest.assertEquals((String)"FeeFoo", (double)m.get(1, 2), (double)m.get("Fee", "Foo"), (double)1.0E-6);
        m.get("Fie", "Foe");
    }

    @Test
    public void testLabelBindingSerialization() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        HashMap rowBindings = Maps.newHashMap();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        rowBindings.put("Foe", 2);
        m.setRowLabelBindings((Map)rowBindings);
        MatrixTest.assertEquals((String)"row", (Object)rowBindings, (Object)m.getRowLabelBindings());
        HashMap colBindings = Maps.newHashMap();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        colBindings.put("Baz", 2);
        m.setColumnLabelBindings((Map)colBindings);
        MatrixTest.assertEquals((String)"col", (Object)colBindings, (Object)m.getColumnLabelBindings());
    }
}

