/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.DoubleShortProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractDoubleShortMap
extends AbstractSet {
    public boolean containsKey(final double key) {
        return !this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final short value) {
        return !this.forEachPair(new DoubleShortProcedure(){

            @Override
            public boolean apply(double iterKey, short iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractDoubleShortMap copy() {
        return (AbstractDoubleShortMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDoubleShortMap)) {
            return false;
        }
        final AbstractDoubleShortMap other = (AbstractDoubleShortMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleShortProcedure(){

            @Override
            public boolean apply(double key, short value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new DoubleShortProcedure(){

            @Override
            public boolean apply(double key, short value) {
                return AbstractDoubleShortMap.this.containsKey(key) && AbstractDoubleShortMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new DoubleShortProcedure(){
            int i = 0;

            @Override
            public boolean apply(double key, short value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleShortProcedure procedure) {
        return this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double key) {
                return procedure.apply(key, AbstractDoubleShortMap.this.get(key));
            }
        });
    }

    public abstract short get(double var1);

    public DoubleArrayList keys() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList keyList) {
        this.pairsSortedByValue(keyList, new ShortArrayList(this.size()));
    }

    public void pairsMatching(final DoubleShortProcedure condition, final DoubleArrayList keyList, final ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new DoubleShortProcedure(){

            @Override
            public boolean apply(double key, short value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final double[] k = keyList.elements();
        final short[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                short t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                double t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(double var1, short var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        DoubleArrayList theKeys = new DoubleArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ShortArrayList values() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double key) {
                list.add(AbstractDoubleShortMap.this.get(key));
                return true;
            }
        });
    }

    public short adjustOrPutValue(double key, short newValue, short incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (short)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

