/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.flavor.BackEnum;
import org.apache.mahout.math.flavor.MatrixFlavor;
import org.apache.mahout.math.flavor.TraversingStructureEnum;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;

class TransposedMatrixView
extends AbstractMatrix {
    private Matrix m;
    private MatrixFlavor flavor = new MatrixFlavor(){

        @Override
        public BackEnum getBacking() {
            return TransposedMatrixView.this.m.getFlavor().getBacking();
        }

        @Override
        public TraversingStructureEnum getStructure() {
            TraversingStructureEnum flavor = TransposedMatrixView.this.m.getFlavor().getStructure();
            switch (flavor) {
                case COLWISE: {
                    return TraversingStructureEnum.ROWWISE;
                }
                case SPARSECOLWISE: {
                    return TraversingStructureEnum.SPARSEROWWISE;
                }
                case ROWWISE: {
                    return TraversingStructureEnum.COLWISE;
                }
                case SPARSEROWWISE: {
                    return TraversingStructureEnum.SPARSECOLWISE;
                }
            }
            return flavor;
        }

        @Override
        public boolean isDense() {
            return TransposedMatrixView.this.m.getFlavor().isDense();
        }
    };

    public TransposedMatrixView(Matrix m) {
        super(m.numCols(), m.numRows());
        this.m = m;
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        this.m.assignRow(column, other);
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        this.m.assignColumn(row, other);
        return this;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.m.getQuick(column, row);
    }

    @Override
    public Matrix like() {
        return this.m.like(this.rows, this.columns);
    }

    @Override
    public Matrix like(int rows, int columns) {
        return this.m.like(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.m.setQuick(column, row, value);
    }

    @Override
    public Vector viewRow(int row) {
        return this.m.viewColumn(row);
    }

    @Override
    public Vector viewColumn(int column) {
        return this.m.viewRow(column);
    }

    @Override
    public Matrix assign(double value) {
        return this.m.assign(value);
    }

    @Override
    public Matrix assign(Matrix other, DoubleDoubleFunction function) {
        if (other instanceof TransposedMatrixView) {
            this.m.assign(((TransposedMatrixView)other).m, function);
        } else {
            this.m.assign(new TransposedMatrixView(other), function);
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix other) {
        if (other instanceof TransposedMatrixView) {
            return this.m.assign(((TransposedMatrixView)other).m);
        }
        return this.m.assign(new TransposedMatrixView(other));
    }

    @Override
    public Matrix assign(DoubleFunction function) {
        return this.m.assign(function);
    }

    @Override
    public MatrixFlavor getFlavor() {
        return this.flavor;
    }

    Matrix getDelegate() {
        return this.m;
    }
}

