/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;

public class MatrixVectorView
extends AbstractVector {
    private Matrix matrix;
    private int row;
    private int column;
    private int rowStride;
    private int columnStride;
    private boolean isDense = true;

    public MatrixVectorView(Matrix matrix, int row, int column, int rowStride, int columnStride, boolean isDense) {
        this(matrix, row, column, rowStride, columnStride);
        this.isDense = isDense;
    }

    public MatrixVectorView(Matrix matrix, int row, int column, int rowStride, int columnStride) {
        super(MatrixVectorView.viewSize(matrix, row, column, rowStride, columnStride));
        if (row < 0 || row >= matrix.rowSize()) {
            throw new IndexException(row, matrix.rowSize());
        }
        if (column < 0 || column >= matrix.columnSize()) {
            throw new IndexException(column, matrix.columnSize());
        }
        this.matrix = matrix;
        this.row = row;
        this.column = column;
        this.rowStride = rowStride;
        this.columnStride = columnStride;
    }

    private static int viewSize(Matrix matrix, int row, int column, int rowStride, int columnStride) {
        if (rowStride != 0 && columnStride != 0) {
            int n1 = (matrix.numRows() - row) / rowStride;
            int n2 = (matrix.numCols() - column) / columnStride;
            return Math.min(n1, n2);
        }
        if (rowStride > 0) {
            return (matrix.numRows() - row) / rowStride;
        }
        return (matrix.numCols() - column) / columnStride;
    }

    @Override
    public boolean isDense() {
        return this.isDense;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        final AbstractVector.LocalElement r = new AbstractVector.LocalElement(this, 0);
        return new Iterator<Vector.Element>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < MatrixVectorView.this.size();
            }

            @Override
            public Vector.Element next() {
                if (this.i >= MatrixVectorView.this.size()) {
                    throw new NoSuchElementException();
                }
                r.index = this.i++;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove from a view");
            }
        };
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new Iterator<Vector.Element>(){
            private final NonZeroElement element = new NonZeroElement();
            private int index = -1;
            private int lookAheadIndex = -1;

            @Override
            public boolean hasNext() {
                if (this.lookAheadIndex == this.index) {
                    this.lookAhead();
                }
                return this.lookAheadIndex < MatrixVectorView.this.size();
            }

            private void lookAhead() {
                ++this.lookAheadIndex;
                while (this.lookAheadIndex < MatrixVectorView.this.size() && MatrixVectorView.this.getQuick(this.lookAheadIndex) == 0.0) {
                    ++this.lookAheadIndex;
                }
            }

            @Override
            public Vector.Element next() {
                if (this.lookAheadIndex == this.index) {
                    this.lookAhead();
                }
                this.index = this.lookAheadIndex;
                if (this.index >= MatrixVectorView.this.size()) {
                    throw new NoSuchElementException();
                }
                this.element.index = this.index;
                return this.element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            class NonZeroElement
            implements Vector.Element {
                int index;

                NonZeroElement() {
                }

                @Override
                public double get() {
                    return MatrixVectorView.this.getQuick(this.index);
                }

                @Override
                public int index() {
                    return this.index;
                }

                @Override
                public void set(double value) {
                    MatrixVectorView.this.invalidateCachedLength();
                    MatrixVectorView.this.setQuick(this.index, value);
                }
            }
        };
    }

    @Override
    public double getQuick(int index) {
        return this.matrix.getQuick(this.row + this.rowStride * index, this.column + this.columnStride * index);
    }

    @Override
    public Vector like() {
        return this.matrix.like(this.size(), 1).viewColumn(0);
    }

    @Override
    public Vector like(int cardinality) {
        return this.matrix.like(cardinality, 1).viewColumn(0);
    }

    @Override
    public void setQuick(int index, double value) {
        this.matrix.setQuick(this.row + this.rowStride * index, this.column + this.columnStride * index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.size();
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return this.matrix.like(rows, columns);
    }

    @Override
    public Vector clone() {
        MatrixVectorView r = (MatrixVectorView)super.clone();
        r.matrix = this.matrix.clone();
        r.row = this.row;
        r.column = this.column;
        r.rowStride = this.rowStride;
        r.columnStride = this.columnStride;
        return r;
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        int[] indices = updates.getIndices();
        double[] values = updates.getValues();
        for (int i = 0; i < updates.getNumMappings(); ++i) {
            this.matrix.setQuick(this.row + this.rowStride * indices[i], this.column + this.columnStride * indices[i], values[i]);
        }
    }
}

