/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.function.ObjectShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenObjectShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectShortHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        OpenObjectShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectShortHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        OpenObjectShortHashMap map2 = (OpenObjectShortHashMap)map.clone();
        map.clear();
        OpenObjectShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        OpenObjectShortHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectShortHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectShortHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        OpenObjectShortHashMapTest.assertTrue((boolean)map.containsValue((short)11));
        OpenObjectShortHashMapTest.assertFalse((boolean)map.containsValue((short)12));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectShortHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectShortHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectShortHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectShortHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectShortProcedure)new ObjectShortProcedure<String>(){

            public boolean apply(String first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)1)).v);
        OpenObjectShortHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)2)).v);
        OpenObjectShortHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).v);
        OpenObjectShortHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectShortProcedure)new ObjectShortProcedure<String>(){
            int count = 0;

            public boolean apply(String first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        OpenObjectShortHashMapTest.assertEquals((long)11L, (long)map.get((Object)"Eleven"));
    }

    @Test
    public void testKeys() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectShortHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectShortHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectShortHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.adjustOrPutValue((Object)"Eleven", (short)1, (short)3);
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)map.get((Object)"Eleven"));
        map.adjustOrPutValue((Object)"Fifteen", (short)1, (short)3);
        OpenObjectShortHashMapTest.assertEquals((long)1L, (long)map.get((Object)"Fifteen"));
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectShortProcedure)new ObjectShortProcedure<String>(){

            public boolean apply(String first, short second) {
                return second % 2 == 0;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectShortHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectShortHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)valueList.get(1));
        OpenObjectShortHashMapTest.assertEquals((long)12L, (long)valueList.get(0));
    }

    @Test
    public void testValues() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenObjectShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectShortHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectShortHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        OpenObjectShortHashMap map2 = (OpenObjectShortHashMap)map.copy();
        map.clear();
        OpenObjectShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        OpenObjectShortHashMap map2 = (OpenObjectShortHashMap)map.copy();
        OpenObjectShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectShortHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        ShortArrayList values = new ShortArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectShortHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectShortHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)values.get(1));
        OpenObjectShortHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectShortHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectShortHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectShortHashMapTest.assertEquals((long)12L, (long)values.get(3));
        OpenObjectShortHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)this.ncKeys[0], (short)11);
        map.put((Object)this.ncKeys[1], (short)12);
        map.put((Object)this.ncKeys[2], (short)13);
        map.put((Object)this.ncKeys[3], (short)14);
        ShortArrayList values = new ShortArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectShortHashMap map = new OpenObjectShortHashMap();
        map.put((Object)"Eleven", (short)11);
        map.put((Object)"Twelve", (short)12);
        map.put((Object)"Thirteen", (short)13);
        map.put((Object)"Fourteen", (short)14);
        ArrayList keys = new ArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectShortHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectShortHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectShortHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectShortHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectShortHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectShortHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectShortHashMapTest.assertEquals((long)14L, (long)values.get(3));
        OpenObjectShortHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        short v;
        String k;

        Pair(String k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

