/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectIntProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenObjectIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectIntHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        OpenObjectIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectIntHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        OpenObjectIntHashMap map2 = (OpenObjectIntHashMap)map.clone();
        map.clear();
        OpenObjectIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        OpenObjectIntHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectIntHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectIntHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        OpenObjectIntHashMapTest.assertTrue((boolean)map.containsValue(11));
        OpenObjectIntHashMapTest.assertFalse((boolean)map.containsValue(12));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectIntHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectIntHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectIntHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectIntHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectIntProcedure)new ObjectIntProcedure<String>(){

            public boolean apply(String first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)1)).v);
        OpenObjectIntHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)2)).v);
        OpenObjectIntHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).v);
        OpenObjectIntHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectIntProcedure)new ObjectIntProcedure<String>(){
            int count = 0;

            public boolean apply(String first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        OpenObjectIntHashMapTest.assertEquals((long)11L, (long)map.get((Object)"Eleven"));
    }

    @Test
    public void testKeys() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectIntHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectIntHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectIntHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.adjustOrPutValue((Object)"Eleven", 1, 3);
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)map.get((Object)"Eleven"));
        map.adjustOrPutValue((Object)"Fifteen", 1, 3);
        OpenObjectIntHashMapTest.assertEquals((long)1L, (long)map.get((Object)"Fifteen"));
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectIntProcedure)new ObjectIntProcedure<String>(){

            public boolean apply(String first, int second) {
                return second % 2 == 0;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectIntHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectIntHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)valueList.get(1));
        OpenObjectIntHashMapTest.assertEquals((long)12L, (long)valueList.get(0));
    }

    @Test
    public void testValues() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenObjectIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectIntHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectIntHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        OpenObjectIntHashMap map2 = (OpenObjectIntHashMap)map.copy();
        map.clear();
        OpenObjectIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        OpenObjectIntHashMap map2 = (OpenObjectIntHashMap)map.copy();
        OpenObjectIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectIntHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        IntArrayList values = new IntArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectIntHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectIntHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)values.get(1));
        OpenObjectIntHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectIntHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectIntHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectIntHashMapTest.assertEquals((long)12L, (long)values.get(3));
        OpenObjectIntHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)this.ncKeys[0], 11);
        map.put((Object)this.ncKeys[1], 12);
        map.put((Object)this.ncKeys[2], 13);
        map.put((Object)this.ncKeys[3], 14);
        IntArrayList values = new IntArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectIntHashMap map = new OpenObjectIntHashMap();
        map.put((Object)"Eleven", 11);
        map.put((Object)"Twelve", 12);
        map.put((Object)"Thirteen", 13);
        map.put((Object)"Fourteen", 14);
        ArrayList keys = new ArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectIntHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectIntHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectIntHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectIntHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectIntHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectIntHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectIntHashMapTest.assertEquals((long)14L, (long)values.get(3));
        OpenObjectIntHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        int v;
        String k;

        Pair(String k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

