/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongDoubleProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        OpenLongDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        OpenLongDoubleHashMap map2 = (OpenLongDoubleHashMap)map.clone();
        map.clear();
        OpenLongDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        OpenLongDoubleHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongDoubleHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        OpenLongDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenLongDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongDoubleHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        map.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongDoubleHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new LongDoubleProcedure(){
            int count = 0;

            public boolean apply(long first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        OpenLongDoubleHashMapTest.assertEquals((double)22.0, (double)map.get(11L), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(0L), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.adjustOrPutValue(11L, 1.0, 3.0);
        OpenLongDoubleHashMapTest.assertEquals((double)25.0, (double)map.get(11L), (double)1.0E-6);
        map.adjustOrPutValue(15L, 1.0, 3.0);
        OpenLongDoubleHashMapTest.assertEquals((double)1.0, (double)map.get(15L), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 22.0);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        map.pairsMatching(new LongDoubleProcedure(){

            public boolean apply(long first, double second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongDoubleHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongDoubleHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenLongDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        OpenLongDoubleHashMap map2 = (OpenLongDoubleHashMap)map.copy();
        map.clear();
        OpenLongDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        OpenLongDoubleHashMap map2 = (OpenLongDoubleHashMap)map.copy();
        OpenLongDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 22.0);
        map.put(12L, 23.0);
        map.put(13L, 24.0);
        map.put(14L, 25.0);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongDoubleHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongDoubleHashMap map = new OpenLongDoubleHashMap();
        map.put(11L, 100.0);
        map.put(12L, 70.0);
        map.put(13L, 30.0);
        map.put(14L, 3.0);
        LongArrayList keys = new LongArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenLongDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        double v;

        Pair(long k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

