/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.ConstantVector;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.jet.random.Normal;
import org.apache.mahout.math.random.MultiNormal;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractVectorTest<T extends Vector>
extends MahoutTestCase {
    private static final double FUZZ = 1.0E-13;
    private static final double[] values = new double[]{1.1, 2.2, 3.3};
    private static final double[] gold = new double[]{0.0, 1.1, 0.0, 2.2, 0.0, 3.3, 0.0};
    private Vector test;

    private static void checkIterator(Iterator<Vector.Element> nzIter, double[] values) {
        while (nzIter.hasNext()) {
            Vector.Element elt = nzIter.next();
            AbstractVectorTest.assertEquals((String)(elt.index() + " Value: " + values[elt.index()] + " does not equal: " + elt.get()), (double)values[elt.index()], (double)elt.get(), (double)0.0);
        }
    }

    public abstract T vectorToTest(int var1);

    @Test
    public void testSimpleOps() {
        T v0 = this.vectorToTest(20);
        RandomWrapper gen = RandomUtils.getRandom();
        Vector v1 = v0.assign((DoubleFunction)new Normal(0.0, 1.0, (Random)gen));
        AbstractVectorTest.assertEquals((double)v0.get(12), (double)v1.get(12), (double)0.0);
        v0.set(12, gen.nextDouble());
        AbstractVectorTest.assertEquals((double)v0.get(12), (double)v1.get(12), (double)0.0);
        AbstractVectorTest.assertSame(v0, (Object)v1);
        Vector v2 = this.vectorToTest(20).assign((DoubleFunction)new Normal(0.0, 1.0, (Random)gen));
        DenseVector dv1 = new DenseVector(v1);
        DenseVector dv2 = new DenseVector(v2);
        RandomAccessSparseVector sv1 = new RandomAccessSparseVector(v1);
        RandomAccessSparseVector sv2 = new RandomAccessSparseVector(v2);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.plus((Vector)dv2).getDistanceSquared(v1.plus(v2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.plus((Vector)dv2).getDistanceSquared(v1.plus((Vector)dv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.plus((Vector)dv2).getDistanceSquared(v1.plus((Vector)sv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.plus((Vector)dv2).getDistanceSquared(sv1.plus(v2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.times((Vector)dv2).getDistanceSquared(v1.times(v2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.times((Vector)dv2).getDistanceSquared(v1.times((Vector)dv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.times((Vector)dv2).getDistanceSquared(v1.times((Vector)sv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.times((Vector)dv2).getDistanceSquared(sv1.times(v2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.minus((Vector)dv2).getDistanceSquared(v1.minus(v2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.minus((Vector)dv2).getDistanceSquared(v1.minus((Vector)dv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.minus((Vector)dv2).getDistanceSquared(v1.minus((Vector)sv2)), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.minus((Vector)dv2).getDistanceSquared(sv1.minus(v2)), (double)1.0E-13);
        double z = gen.nextDouble();
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.divide(z).getDistanceSquared(v1.divide(z)), (double)1.0E-12);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.times(z).getDistanceSquared(v1.times(z)), (double)1.0E-12);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.plus(z).getDistanceSquared(v1.plus(z)), (double)1.0E-12);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)v1.dot(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)v1.dot((Vector)dv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)v1.dot((Vector)sv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)sv1.dot(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)dv1.dot(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)dv1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)sv1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared((Vector)dv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared((Vector)sv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getLengthSquared(), (double)v1.getLengthSquared(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)dv1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)sv1.getDistanceSquared(v2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared((Vector)dv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.getDistanceSquared((Vector)dv2), (double)v1.getDistanceSquared((Vector)sv2), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.minValue(), (double)v1.minValue(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((long)dv1.minValueIndex(), (long)v1.minValueIndex());
        AbstractVectorTest.assertEquals((double)dv1.maxValue(), (double)v1.maxValue(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((long)dv1.maxValueIndex(), (long)v1.maxValueIndex());
        Vector nv1 = v1.normalize();
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.getDistanceSquared(v1), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)1.0, (double)nv1.norm(2.0), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.normalize().getDistanceSquared(nv1), (double)1.0E-13);
        nv1 = v1.normalize(1.0);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.getDistanceSquared(v1), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)1.0, (double)nv1.norm(1.0), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.normalize(1.0).getDistanceSquared(nv1), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.norm(0.0), (double)v1.norm(0.0), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.norm(1.0), (double)v1.norm(1.0), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.norm(1.5), (double)v1.norm(1.5), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.norm(2.0), (double)v1.norm(2.0), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.zSum(), (double)v1.zSum(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)(3.1 * (double)v1.size()), (double)v1.assign(3.1).zSum(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)v1.plus(-3.1).norm(1.0), (double)1.0E-13);
        v1.assign((Vector)dv1);
        AbstractVectorTest.assertEquals((double)0.0, (double)v1.getDistanceSquared((Vector)dv1), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)(dv1.zSum() - (double)dv1.size() * 3.4), (double)v1.assign(Functions.minus((double)3.4)).zSum(), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)(dv1.zSum() - (double)dv1.size() * 4.5), (double)v1.assign(Functions.MINUS, 1.1).zSum(), (double)1.0E-13);
        v1.assign((Vector)dv1);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.minus((Vector)dv2).getDistanceSquared(v1.assign(v2, Functions.MINUS)), (double)1.0E-13);
        v1.assign((Vector)dv1);
        AbstractVectorTest.assertEquals((double)dv1.norm(2.0), (double)Math.sqrt(v1.aggregate(Functions.PLUS, Functions.pow((double)2.0))), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.dot((Vector)dv2), (double)v1.aggregate(v2, Functions.PLUS, Functions.MULT), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)dv1.viewPart(5, 10).zSum(), (double)v1.viewPart(5, 10).zSum(), (double)1.0E-13);
        Vector v3 = v1.clone();
        AbstractVectorTest.assertTrue((boolean)v0.getClass().isAssignableFrom(v3.getClass()));
        AbstractVectorTest.assertTrue((boolean)v3.getClass().isAssignableFrom(v0.getClass()));
        AbstractVectorTest.assertEquals((double)0.0, (double)v1.getDistanceSquared(v3), (double)1.0E-13);
        AbstractVectorTest.assertNotSame((Object)v1, (Object)v3);
        v3.assign(0.0);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.getDistanceSquared(v1), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)v3.getLengthSquared(), (double)1.0E-13);
        dv1.assign(Functions.ABS);
        v1.assign(Functions.ABS);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.logNormalize().getDistanceSquared(v1.logNormalize()), (double)1.0E-13);
        AbstractVectorTest.assertEquals((double)0.0, (double)dv1.logNormalize(1.5).getDistanceSquared(v1.logNormalize(1.5)), (double)1.0E-13);
        for (Vector.Element element : v1.all()) {
            AbstractVectorTest.assertEquals((double)dv1.get(element.index()), (double)element.get(), (double)0.0);
            AbstractVectorTest.assertEquals((double)dv1.get(element.index()), (double)v1.get(element.index()), (double)0.0);
            AbstractVectorTest.assertEquals((double)dv1.get(element.index()), (double)v1.getQuick(element.index()), (double)0.0);
        }
    }

    abstract Vector generateTestVector(int var1);

    Vector getTestVector() {
        return this.test;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.test = this.generateTestVector(2 * values.length + 1);
        for (int i = 0; i < values.length; ++i) {
            this.test.set(2 * i + 1, values[i]);
        }
    }

    @Test
    public void testCardinality() {
        AbstractVectorTest.assertEquals((String)"size", (long)7L, (long)this.test.size());
    }

    @Test
    public void testIterator() {
        int i;
        Iterator iterator = this.test.nonZeroes().iterator();
        AbstractVectorTest.checkIterator(iterator, gold);
        iterator = this.test.all().iterator();
        AbstractVectorTest.checkIterator(iterator, gold);
        double[] doubles = new double[]{0.0, 5.0, 0.0, 3.0};
        RandomAccessSparseVector zeros = new RandomAccessSparseVector(doubles.length);
        for (i = 0; i < doubles.length; ++i) {
            zeros.setQuick(i, doubles[i]);
        }
        iterator = zeros.iterateNonZero();
        AbstractVectorTest.checkIterator(iterator, doubles);
        iterator = zeros.iterator();
        AbstractVectorTest.checkIterator(iterator, doubles);
        doubles = new double[]{0.0, 0.0, 0.0, 0.0};
        zeros = new RandomAccessSparseVector(doubles.length);
        for (i = 0; i < doubles.length; ++i) {
            zeros.setQuick(i, doubles[i]);
        }
        iterator = zeros.iterateNonZero();
        AbstractVectorTest.checkIterator(iterator, doubles);
        iterator = zeros.iterator();
        AbstractVectorTest.checkIterator(iterator, doubles);
    }

    @Test
    public void testIteratorSet() {
        Vector clone = this.test.clone();
        for (Vector.Element e : clone.nonZeroes()) {
            e.set(e.get() * 2.0);
        }
        for (Vector.Element e : clone.nonZeroes()) {
            AbstractVectorTest.assertEquals((double)(this.test.get(e.index()) * 2.0), (double)e.get(), (double)1.0E-6);
        }
        clone = this.test.clone();
        for (Vector.Element e : clone.all()) {
            e.set(e.get() * 2.0);
        }
        for (Vector.Element e : clone.all()) {
            AbstractVectorTest.assertEquals((double)(this.test.get(e.index()) * 2.0), (double)e.get(), (double)1.0E-6);
        }
    }

    @Test
    public void testCopy() {
        Vector copy = this.test.clone();
        for (int i = 0; i < this.test.size(); ++i) {
            AbstractVectorTest.assertEquals((String)("copy [" + i + ']'), (double)this.test.get(i), (double)copy.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testGet() {
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)values[i / 2], (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testGetOver() {
        this.test.get(this.test.size());
    }

    @Test(expected=IndexException.class)
    public void testGetUnder() {
        this.test.get(-1);
    }

    @Test
    public void testSet() {
        this.test.set(3, 4.5);
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            if (i == 3) {
                AbstractVectorTest.assertEquals((String)("set [" + i + ']'), (double)4.5, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("set [" + i + ']'), (double)values[i / 2], (double)this.test.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testSize() {
        AbstractVectorTest.assertEquals((String)"size", (long)3L, (long)this.test.getNumNondefaultElements());
    }

    @Test
    public void testViewPart() {
        Vector part = this.test.viewPart(1, 2);
        AbstractVectorTest.assertEquals((String)"part size", (long)2L, (long)part.getNumNondefaultElements());
        for (int i = 0; i < part.size(); ++i) {
            AbstractVectorTest.assertEquals((String)("part[" + i + ']'), (double)this.test.get(i + 1), (double)part.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartUnder() {
        this.test.viewPart(-1, values.length);
    }

    @Test(expected=IndexException.class)
    public void testViewPartOver() {
        this.test.viewPart(2, 7);
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        this.test.viewPart(1, 8);
    }

    @Test
    public void testSparseDoubleVectorInt() {
        RandomAccessSparseVector val = new RandomAccessSparseVector(4);
        AbstractVectorTest.assertEquals((String)"size", (long)4L, (long)val.size());
        for (int i = 0; i < 4; ++i) {
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDot() {
        double res = this.test.dot(this.test);
        double expected = 16.94;
        AbstractVectorTest.assertEquals((String)"dot", (double)expected, (double)res, (double)1.0E-6);
    }

    @Test
    public void testDot2() {
        Vector test2 = this.test.clone();
        test2.set(1, 0.0);
        test2.set(3, 0.0);
        AbstractVectorTest.assertEquals((double)10.889999999999999, (double)test2.dot(this.test), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testDotCardinality() {
        this.test.dot((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testNormalize() {
        Vector val = this.test.normalize();
        double mag = Math.sqrt(16.939999999999998);
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)"dot", (double)(values[i / 2] / mag), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testMinus() {
        int i;
        int i2;
        Vector val = this.test.minus(this.test);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (i2 = 0; i2 < this.test.size(); ++i2) {
            AbstractVectorTest.assertEquals((String)("get [" + i2 + ']'), (double)0.0, (double)val.get(i2), (double)1.0E-6);
        }
        val = this.test.minus(this.test).minus(this.test);
        AbstractVectorTest.assertEquals((String)"cardinality", (long)this.test.size(), (long)val.size());
        for (i2 = 0; i2 < this.test.size(); ++i2) {
            AbstractVectorTest.assertEquals((String)("get [" + i2 + ']'), (double)0.0, (double)(val.get(i2) + this.test.get(i2)), (double)1.0E-6);
        }
        Vector val1 = this.test.plus(1.0);
        val = val1.minus(this.test);
        for (i = 0; i < this.test.size(); ++i) {
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)1.0, (double)val.get(i), (double)1.0E-6);
        }
        val1 = this.test.plus(-1.0);
        val = val1.minus(this.test);
        for (i = 0; i < this.test.size(); ++i) {
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)-1.0, (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusDouble() {
        Vector val = this.test.plus(1.0);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)1.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] + 1.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPlusVector() {
        Vector val = this.test.plus(this.test);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * 2.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusVectorCardinality() {
        this.test.plus((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testTimesDouble() {
        Vector val = this.test.times(3.0);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDivideDouble() {
        Vector val = this.test.divide(3.0);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] / 3.0), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testTimesVector() {
        Vector val = this.test.times(this.test);
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)val.size());
        for (int i = 0; i < this.test.size(); ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)val.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)(values[i / 2] * values[i / 2]), (double)val.get(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testTimesVectorCardinality() {
        this.test.times((Vector)new DenseVector(this.test.size() + 1));
    }

    @Test
    public void testZSum() {
        double expected = 0.0;
        for (double value : values) {
            expected += value;
        }
        AbstractVectorTest.assertEquals((String)"wrong zSum", (double)expected, (double)this.test.zSum(), (double)1.0E-6);
    }

    @Test
    public void testGetDistanceSquared() {
        RandomAccessSparseVector other = new RandomAccessSparseVector(this.test.size());
        other.set(1, -2.0);
        other.set(2, -5.0);
        other.set(3, -9.0);
        other.set(4, 1.0);
        double expected = this.test.minus((Vector)other).getLengthSquared();
        AbstractVectorTest.assertTrue((String)"a.getDistanceSquared(b) != a.minus(b).getLengthSquared", (Math.abs(expected - this.test.getDistanceSquared((Vector)other)) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testAssignDouble() {
        this.test.assign(0.0);
        for (int i = 0; i < values.length; ++i) {
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignDoubleArray() {
        double[] array = new double[this.test.size()];
        this.test.assign(array);
        for (int i = 0; i < values.length; ++i) {
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayCardinality() {
        double[] array = new double[this.test.size() + 1];
        this.test.assign(array);
    }

    @Test
    public void testAssignVector() {
        DenseVector other = new DenseVector(this.test.size());
        this.test.assign((Vector)other);
        for (int i = 0; i < values.length; ++i) {
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)0.0, (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignVectorCardinality() {
        DenseVector other = new DenseVector(this.test.size() - 1);
        this.test.assign((Vector)other);
    }

    @Test
    public void testAssignUnaryFunction() {
        this.test.assign(Functions.NEGATE);
        for (int i = 1; i < values.length; i += 2) {
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)(-values[i]), (double)this.test.getQuick(i + 2), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction() {
        this.test.assign(this.test, Functions.PLUS);
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)(2.0 * values[i - 1]), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction2() {
        this.test.assign(Functions.plus((double)4.0));
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)4.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)(values[i - 1] + 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAssignBinaryFunction3() {
        this.test.assign(Functions.mult((double)4.0));
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                AbstractVectorTest.assertEquals((String)("get [" + i + ']'), (double)0.0, (double)this.test.get(i), (double)1.0E-6);
                continue;
            }
            AbstractVectorTest.assertEquals((String)("value[" + i + ']'), (double)(values[i - 1] * 4.0), (double)this.test.getQuick(i), (double)1.0E-6);
        }
    }

    @Test
    public void testLike() {
        Vector other = this.test.like();
        AbstractVectorTest.assertTrue((String)"not like", (boolean)this.test.getClass().isAssignableFrom(other.getClass()));
        AbstractVectorTest.assertEquals((String)"size", (long)this.test.size(), (long)other.size());
    }

    @Test
    public void testCrossProduct() {
        Matrix result = this.test.cross(this.test);
        AbstractVectorTest.assertEquals((String)"row size", (long)this.test.size(), (long)result.rowSize());
        AbstractVectorTest.assertEquals((String)"col size", (long)this.test.size(), (long)result.columnSize());
        for (int row = 0; row < result.rowSize(); ++row) {
            for (int col = 0; col < result.columnSize(); ++col) {
                AbstractVectorTest.assertEquals((String)("cross[" + row + "][" + col + ']'), (double)(this.test.getQuick(row) * this.test.getQuick(col)), (double)result.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testIterators() {
        T v0 = this.vectorToTest(20);
        double sum = 0.0;
        int elements = 0;
        int nonZero = 0;
        for (Vector.Element element : v0.all()) {
            ++elements;
            sum += element.get();
            if (element.get() == 0.0) continue;
            ++nonZero;
        }
        int nonZeroIterated = Iterables.size((Iterable)v0.nonZeroes());
        AbstractVectorTest.assertEquals((long)20L, (long)elements);
        AbstractVectorTest.assertEquals((long)v0.size(), (long)elements);
        AbstractVectorTest.assertEquals((long)nonZeroIterated, (long)nonZero);
        AbstractVectorTest.assertEquals((double)v0.zSum(), (double)sum, (double)0.0);
    }

    @Test
    public void testSmallDistances() {
        for (double fuzz : new double[]{1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10}) {
            MultiNormal x = new MultiNormal(fuzz, (Vector)new ConstantVector(0.0, 20));
            for (int i = 0; i < 10000; ++i) {
                String msg;
                T v1 = this.vectorToTest(20);
                Vector v2 = v1.plus(x.sample());
                if (1.0 + fuzz * fuzz > 1.0) {
                    msg = String.format("fuzz = %.1g, >", fuzz);
                    AbstractVectorTest.assertTrue((String)msg, (v1.getDistanceSquared(v2) > 0.0 ? 1 : 0) != 0);
                    AbstractVectorTest.assertTrue((String)msg, (v2.getDistanceSquared(v1) > 0.0 ? 1 : 0) != 0);
                    continue;
                }
                msg = String.format("fuzz = %.1g, >=", fuzz);
                AbstractVectorTest.assertTrue((String)msg, (v1.getDistanceSquared(v2) >= 0.0 ? 1 : 0) != 0);
                AbstractVectorTest.assertTrue((String)msg, (v2.getDistanceSquared(v1) >= 0.0 ? 1 : 0) != 0);
            }
        }
    }

    public void testToString() {
        Vector w = this.generateTestVector(20);
        w.set(0, 1.1);
        w.set(13, 100500.0);
        w.set(19, 3.141592);
        AbstractVectorTest.assertEquals((Object)"{0:1.1,13:100500.0,19:3.141592}", (Object)w.toString());
        w = this.generateTestVector(12);
        w.set(10, 0.1);
        AbstractVectorTest.assertEquals((Object)"{10:0.1}", (Object)w.toString());
        w = this.generateTestVector(12);
        AbstractVectorTest.assertEquals((Object)"{}", (Object)w.toString());
    }
}

