/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public class HashUtilsTest
extends TestCase {
    public void testHashFloat() {
        HashMultiset violations = HashMultiset.create();
        for (int k = 0; k < 1000; ++k) {
            ArrayList original = Lists.newArrayList();
            RandomWrapper gen = RandomUtils.getRandom();
            for (int i = 0; i < 10000; ++i) {
                float x = (float)gen.nextDouble();
                original.add(Float.valueOf(x));
            }
            violations.add((Object)(HashUtilsTest.checkCounts(original) <= 12 ? 0 : 1));
        }
        HashUtilsTest.assertTrue((violations.count((Object)0) >= 985 ? 1 : 0) != 0);
    }

    public void testHashDouble() {
        ArrayList original = Lists.newArrayList();
        for (int k = 0; k < 10; ++k) {
            RandomWrapper gen = RandomUtils.getRandom();
            for (int i = 0; i < 10000; ++i) {
                double x = gen.nextDouble();
                original.add(x);
            }
            HashUtilsTest.checkCounts(original);
        }
    }

    public void testHashLong() {
        ArrayList original = Lists.newArrayList();
        for (int k = 0; k < 10; ++k) {
            RandomWrapper gen = RandomUtils.getRandom();
            for (int i = 0; i < 10000; ++i) {
                long x = gen.nextLong();
                original.add(x);
            }
            HashUtilsTest.checkCounts(original);
        }
    }

    private static <T> int checkCounts(Collection<T> original) {
        HashMultiset hashCounts = HashMultiset.create();
        for (T v : original) {
            hashCounts.add(v);
        }
        HashMultiset countCounts = HashMultiset.create();
        for (Object hash : hashCounts) {
            countCounts.add((Object)hashCounts.count(hash));
        }
        return original.size() - countCounts.count((Object)1);
    }
}

