/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.function.IntShortProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenIntShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        OpenIntShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntShortHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        OpenIntShortHashMap map2 = (OpenIntShortHashMap)map.clone();
        map.clear();
        OpenIntShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        OpenIntShortHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntShortHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        OpenIntShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenIntShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntShortHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        map.forEachPair(new IntShortProcedure(){

            public boolean apply(int first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenIntShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenIntShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new IntShortProcedure(){
            int count = 0;

            public boolean apply(int first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        OpenIntShortHashMapTest.assertEquals((long)22L, (long)map.get(11));
        OpenIntShortHashMapTest.assertEquals((long)0L, (long)map.get(0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.adjustOrPutValue(11, (short)1, (short)3);
        OpenIntShortHashMapTest.assertEquals((long)25L, (long)map.get(11));
        map.adjustOrPutValue(15, (short)1, (short)3);
        OpenIntShortHashMapTest.assertEquals((long)1L, (long)map.get(15));
    }

    @Test
    public void testKeys() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)22);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        map.pairsMatching(new IntShortProcedure(){

            public boolean apply(int first, short second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntShortHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntShortHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenIntShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenIntShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenIntShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenIntShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        OpenIntShortHashMap map2 = (OpenIntShortHashMap)map.copy();
        map.clear();
        OpenIntShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        OpenIntShortHashMap map2 = (OpenIntShortHashMap)map.copy();
        OpenIntShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)22);
        map.put(12, (short)23);
        map.put(13, (short)24);
        map.put(14, (short)25);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntShortHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntShortHashMap map = new OpenIntShortHashMap();
        map.put(11, (short)100);
        map.put(12, (short)70);
        map.put(13, (short)30);
        map.put(14, (short)3);
        IntArrayList keys = new IntArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenIntShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenIntShortHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenIntShortHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntShortHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenIntShortHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenIntShortHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenIntShortHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        short v;

        Pair(int k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

