/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleLongProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenDoubleLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        OpenDoubleLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleLongHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        OpenDoubleLongHashMap map2 = (OpenDoubleLongHashMap)map.clone();
        map.clear();
        OpenDoubleLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        OpenDoubleLongHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleLongHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        OpenDoubleLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenDoubleLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleLongHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        map.forEachPair(new DoubleLongProcedure(){

            public boolean apply(double first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleLongHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenDoubleLongHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenDoubleLongHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new DoubleLongProcedure(){
            int count = 0;

            public boolean apply(double first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        OpenDoubleLongHashMapTest.assertEquals((long)22L, (long)map.get(11.0));
        OpenDoubleLongHashMapTest.assertEquals((long)0L, (long)map.get(0.0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.adjustOrPutValue(11.0, 1L, 3L);
        OpenDoubleLongHashMapTest.assertEquals((long)25L, (long)map.get(11.0));
        map.adjustOrPutValue(15.0, 1L, 3L);
        OpenDoubleLongHashMapTest.assertEquals((long)1L, (long)map.get(15.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 22L);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleLongHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleLongProcedure(){

            public boolean apply(double first, long second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleLongHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenDoubleLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenDoubleLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenDoubleLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenDoubleLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        OpenDoubleLongHashMap map2 = (OpenDoubleLongHashMap)map.copy();
        map.clear();
        OpenDoubleLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        OpenDoubleLongHashMap map2 = (OpenDoubleLongHashMap)map.copy();
        OpenDoubleLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 22L);
        map.put(12.0, 23L);
        map.put(13.0, 24L);
        map.put(14.0, 25L);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleLongHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleLongHashMap map = new OpenDoubleLongHashMap();
        map.put(11.0, 100L);
        map.put(12.0, 70L);
        map.put(13.0, 30L);
        map.put(14.0, 3L);
        DoubleArrayList keys = new DoubleArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleLongHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenDoubleLongHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenDoubleLongHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenDoubleLongHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleLongHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenDoubleLongHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenDoubleLongHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenDoubleLongHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        long v;

        Pair(double k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

