/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleFloatProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenDoubleFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        OpenDoubleFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenDoubleFloatHashMapTest.assertEquals((double)0.0, (double)map.get(11.0), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        OpenDoubleFloatHashMap map2 = (OpenDoubleFloatHashMap)map.clone();
        map.clear();
        OpenDoubleFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        OpenDoubleFloatHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleFloatHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        OpenDoubleFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenDoubleFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleFloatHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        map.forEachPair(new DoubleFloatProcedure(){

            public boolean apply(double first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleFloatHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)22.0f, (float)((Pair)pairs.get((int)0)).v, (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)23.0f, (float)((Pair)pairs.get((int)1)).v, (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)25.0f, (float)((Pair)pairs.get((int)2)).v, (float)1.0E-6f);
        pairs.clear();
        map.forEachPair(new DoubleFloatProcedure(){
            int count = 0;

            public boolean apply(double first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        OpenDoubleFloatHashMapTest.assertEquals((float)22.0f, (float)map.get(11.0), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((float)0.0f, (float)map.get(0.0), (float)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.adjustOrPutValue(11.0, 1.0f, 3.0f);
        OpenDoubleFloatHashMapTest.assertEquals((float)25.0f, (float)map.get(11.0), (float)1.0E-6f);
        map.adjustOrPutValue(15.0, 1.0f, 3.0f);
        OpenDoubleFloatHashMapTest.assertEquals((float)1.0f, (float)map.get(15.0), (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 22.0f);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleFloatHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        map.pairsMatching(new DoubleFloatProcedure(){

            public boolean apply(double first, float second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenDoubleFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleFloatHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)23.0f, (float)valueList.get(0), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((float)25.0f, (float)valueList.get(1), (float)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenDoubleFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenDoubleFloatHashMapTest.assertEquals((float)22.0f, (float)values.get(0), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((float)23.0f, (float)values.get(1), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((float)25.0f, (float)values.get(2), (float)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        OpenDoubleFloatHashMap map2 = (OpenDoubleFloatHashMap)map.copy();
        map.clear();
        OpenDoubleFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        OpenDoubleFloatHashMap map2 = (OpenDoubleFloatHashMap)map.copy();
        OpenDoubleFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 22.0f);
        map.put(12.0, 23.0f);
        map.put(13.0, 24.0f);
        map.put(14.0, 25.0f);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleFloatHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleFloatHashMap map = new OpenDoubleFloatHashMap();
        map.put(11.0, 100.0f);
        map.put(12.0, 70.0f);
        map.put(13.0, 30.0f);
        map.put(14.0, 3.0f);
        DoubleArrayList keys = new DoubleArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleFloatHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(0), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(1), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(2), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(3), (float)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenDoubleFloatHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(3), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(2), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(1), (float)1.0E-6f);
        OpenDoubleFloatHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(0), (float)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        float v;

        Pair(double k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

