/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharIntProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenCharIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        OpenCharIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharIntHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        OpenCharIntHashMap map2 = (OpenCharIntHashMap)map.clone();
        map.clear();
        OpenCharIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        OpenCharIntHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharIntHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        OpenCharIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenCharIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharIntHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        map.forEachPair(new CharIntProcedure(){

            public boolean apply(char first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenCharIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenCharIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new CharIntProcedure(){
            int count = 0;

            public boolean apply(char first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        OpenCharIntHashMapTest.assertEquals((long)22L, (long)map.get('\u000b'));
        OpenCharIntHashMapTest.assertEquals((long)0L, (long)map.get('\u0000'));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.adjustOrPutValue('\u000b', 1, 3);
        OpenCharIntHashMapTest.assertEquals((long)25L, (long)map.get('\u000b'));
        map.adjustOrPutValue('\u000f', 1, 3);
        OpenCharIntHashMapTest.assertEquals((long)1L, (long)map.get('\u000f'));
    }

    @Test
    public void testKeys() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 22);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        map.pairsMatching(new CharIntProcedure(){

            public boolean apply(char first, int second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharIntHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharIntHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenCharIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenCharIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenCharIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenCharIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        OpenCharIntHashMap map2 = (OpenCharIntHashMap)map.copy();
        map.clear();
        OpenCharIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        OpenCharIntHashMap map2 = (OpenCharIntHashMap)map.copy();
        OpenCharIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 22);
        map.put('\f', 23);
        map.put('\r', 24);
        map.put('\u000e', 25);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharIntHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharIntHashMap map = new OpenCharIntHashMap();
        map.put('\u000b', 100);
        map.put('\f', 70);
        map.put('\r', 30);
        map.put('\u000e', 3);
        CharArrayList keys = new CharArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenCharIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenCharIntHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenCharIntHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharIntHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenCharIntHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenCharIntHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenCharIntHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        int v;

        Pair(char k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

