/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorBinaryAssign;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class VectorBinaryAssignCostTest {
    RandomAccessSparseVector realRasv = new RandomAccessSparseVector(1000000);
    SequentialAccessSparseVector realSasv = new SequentialAccessSparseVector(1000000);
    DenseVector realDense = new DenseVector(1000000);
    Vector rasv = (Vector)EasyMock.createMock(Vector.class);
    Vector sasv = (Vector)EasyMock.createMock(Vector.class);
    Vector dense = (Vector)EasyMock.createMock(Vector.class);

    private static void createStubs(Vector v, Vector realV) {
        EasyMock.expect((Object)v.getLookupCost()).andStubReturn((Object)(realV instanceof SequentialAccessSparseVector ? (double)Math.round(Math.log(1000.0)) : realV.getLookupCost()));
        EasyMock.expect((Object)v.getIteratorAdvanceCost()).andStubReturn((Object)realV.getIteratorAdvanceCost());
        EasyMock.expect((Object)v.isAddConstantTime()).andStubReturn((Object)realV.isAddConstantTime());
        EasyMock.expect((Object)v.isSequentialAccess()).andStubReturn((Object)realV.isSequentialAccess());
        EasyMock.expect((Object)v.isDense()).andStubReturn((Object)realV.isDense());
        EasyMock.expect((Object)v.getNumNondefaultElements()).andStubReturn((Object)(realV.isDense() ? realV.size() : 1000));
        EasyMock.expect((Object)v.size()).andStubReturn((Object)realV.size());
    }

    @Before
    public void setUpStubs() {
        VectorBinaryAssignCostTest.createStubs(this.dense, (Vector)this.realDense);
        VectorBinaryAssignCostTest.createStubs(this.sasv, (Vector)this.realSasv);
        VectorBinaryAssignCostTest.createStubs(this.rasv, (Vector)this.realRasv);
    }

    @Test
    public void denseInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.dense, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.dense, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.dense, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllLoopInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.dense, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.dense, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void sasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignIterateUnionSequentialMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignIterateUnionSequentialMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignIterateUnionSequentialMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllIterateSequentialMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignIterateUnionSequentialMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void rasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllLoopInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void sasvDenseInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllIterateThisLookupThatMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void denseSasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.sasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignIterateUnionSequentialInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.sasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.sasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void denseRasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.rasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllLoopInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.rasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.dense, (Vector)this.rasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void rasvDenseInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllLoopInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.dense, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void sasvRasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllIterateThisLookupThatMergeUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.sasv, (Vector)this.rasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    @Test
    public void rasvSasvInteractions() {
        this.replayAll();
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.PLUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MINUS).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThisLookupThat.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.MULT).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignAllIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.DIV).getClass());
        Assert.assertEquals(VectorBinaryAssign.AssignNonzerosIterateThatLookupThisInplaceUpdates.class, VectorBinaryAssign.getBestOperation((Vector)this.rasv, (Vector)this.sasv, (DoubleDoubleFunction)Functions.SECOND_LEFT_ZERO).getClass());
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.dense, this.sasv, this.rasv});
    }
}

