/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.junit.Test;

public final class TestOrderedIntDoubleMapping
extends MahoutTestCase {
    @Test
    public void testGetSet() {
        OrderedIntDoubleMapping mapping = new OrderedIntDoubleMapping(1);
        TestOrderedIntDoubleMapping.assertEquals((long)0L, (long)mapping.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(1), (double)1.0E-6);
        mapping.set(0, 1.1);
        TestOrderedIntDoubleMapping.assertEquals((long)1L, (long)mapping.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)1.1, (double)mapping.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(1), (double)1.0E-6);
        mapping.set(5, 6.6);
        TestOrderedIntDoubleMapping.assertEquals((long)2L, (long)mapping.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)1.1, (double)mapping.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(1), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)6.6, (double)mapping.get(5), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(6), (double)1.0E-6);
        mapping.set(0, 0.0);
        TestOrderedIntDoubleMapping.assertEquals((long)1L, (long)mapping.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(1), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)6.6, (double)mapping.get(5), (double)1.0E-6);
        mapping.set(5, 0.0);
        TestOrderedIntDoubleMapping.assertEquals((long)0L, (long)mapping.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(1), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)mapping.get(5), (double)1.0E-6);
    }

    @Test
    public void testClone() throws Exception {
        OrderedIntDoubleMapping mapping = new OrderedIntDoubleMapping(1);
        mapping.set(0, 1.1);
        mapping.set(5, 6.6);
        OrderedIntDoubleMapping clone = mapping.clone();
        TestOrderedIntDoubleMapping.assertEquals((long)2L, (long)clone.getNumMappings());
        TestOrderedIntDoubleMapping.assertEquals((double)1.1, (double)clone.get(0), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)clone.get(1), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)6.6, (double)clone.get(5), (double)1.0E-6);
        TestOrderedIntDoubleMapping.assertEquals((double)0.0, (double)clone.get(6), (double)1.0E-6);
    }

    @Test
    public void testAddDefaultElements() {
        OrderedIntDoubleMapping mapping = new OrderedIntDoubleMapping(false);
        mapping.set(1, 1.1);
        TestOrderedIntDoubleMapping.assertEquals((long)1L, (long)mapping.getNumMappings());
        mapping.set(2, 0.0);
        TestOrderedIntDoubleMapping.assertEquals((long)2L, (long)mapping.getNumMappings());
        mapping.set(0, 0.0);
        TestOrderedIntDoubleMapping.assertEquals((long)3L, (long)mapping.getNumMappings());
    }

    @Test
    public void testMerge() {
        OrderedIntDoubleMapping mappingOne = new OrderedIntDoubleMapping(false);
        mappingOne.set(0, 0.0);
        mappingOne.set(2, 2.0);
        mappingOne.set(4, 4.0);
        mappingOne.set(10, 10.0);
        OrderedIntDoubleMapping mappingTwo = new OrderedIntDoubleMapping();
        mappingTwo.set(1, 1.0);
        mappingTwo.set(3, 3.0);
        mappingTwo.set(5, 5.0);
        mappingTwo.set(10, 20.0);
        mappingOne.merge(mappingTwo);
        TestOrderedIntDoubleMapping.assertEquals((long)7L, (long)mappingOne.getNumMappings());
        for (int i = 0; i < 6; ++i) {
            TestOrderedIntDoubleMapping.assertEquals((double)i, (double)mappingOne.get(i), (double)i);
        }
        TestOrderedIntDoubleMapping.assertEquals((double)20.0, (double)mappingOne.get(10), (double)0.0);
    }
}

