/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixTest;
import org.apache.mahout.math.PivotedMatrix;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public class PivotedMatrixTest
extends MatrixTest {
    @Override
    public Matrix matrixFactory(double[][] values) {
        DenseMatrix base = new DenseMatrix(values);
        PivotedMatrix pm = new PivotedMatrix(base.like());
        pm.swap(0, 1);
        pm.swapRows(1, 2);
        pm.assign((Matrix)base);
        return pm;
    }

    @Test
    public void testSwap() {
        DenseMatrix m = new DenseMatrix(10, 10);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                m.set(i, j, (double)(10 * i + j));
            }
        }
        PivotedMatrix pm = new PivotedMatrix((Matrix)m);
        pm.swap(3, 5);
        PivotedMatrixTest.assertEquals((double)0.0, (double)pm.viewDiagonal().minus((Vector)new DenseVector(new double[]{0.0, 11.0, 22.0, 55.0, 44.0, 33.0, 66.0, 77.0, 88.0, 99.0})).norm(1.0), (double)1.0E-10);
        pm.swap(2, 7);
        PivotedMatrixTest.assertEquals((double)0.0, (double)pm.viewDiagonal().minus((Vector)new DenseVector(new double[]{0.0, 11.0, 77.0, 55.0, 44.0, 33.0, 66.0, 22.0, 88.0, 99.0})).norm(1.0), (double)1.0E-10);
        pm.swap(5, 8);
        PivotedMatrixTest.assertEquals((double)0.0, (double)pm.viewColumn(4).minus((Vector)new DenseVector(new double[]{4.0, 14.0, 74.0, 54.0, 44.0, 84.0, 64.0, 24.0, 34.0, 94.0})).norm(1.0), (double)1.0E-10);
        PivotedMatrixTest.assertEquals((double)0.0, (double)pm.viewDiagonal().minus((Vector)new DenseVector(new double[]{0.0, 11.0, 77.0, 55.0, 44.0, 88.0, 66.0, 22.0, 33.0, 99.0})).norm(1.0), (double)1.0E-10);
    }
}

