/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.FloatShortProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractFloatShortMap
extends AbstractSet {
    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final short value) {
        return !this.forEachPair(new FloatShortProcedure(){

            @Override
            public boolean apply(float iterKey, short iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatShortMap copy() {
        return (AbstractFloatShortMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatShortMap)) {
            return false;
        }
        final AbstractFloatShortMap other = (AbstractFloatShortMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatShortProcedure(){

            @Override
            public boolean apply(float key, short value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatShortProcedure(){

            @Override
            public boolean apply(float key, short value) {
                return AbstractFloatShortMap.this.containsKey(key) && AbstractFloatShortMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new FloatShortProcedure(){
            int i = 0;

            @Override
            public boolean apply(float key, short value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatShortProcedure procedure) {
        return this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatShortMap.this.get(key));
            }
        });
    }

    public abstract short get(float var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new ShortArrayList(this.size()));
    }

    public void pairsMatching(final FloatShortProcedure condition, final FloatArrayList keyList, final ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatShortProcedure(){

            @Override
            public boolean apply(float key, short value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] k = keyList.elements();
        final short[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                short t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, short var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ShortArrayList values() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                list.add(AbstractFloatShortMap.this.get(key));
                return true;
            }
        });
    }

    public short adjustOrPutValue(float key, short newValue, short incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (short)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

