/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import java.util.Arrays;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.Gamma;
import org.apache.mahout.math.stats.OnlineSummarizer;
import org.junit.Test;

public final class OnlineSummarizerTest
extends MahoutTestCase {
    @Test
    public void testStats() {
        System.out.printf("normal\n", new Object[0]);
        OnlineSummarizerTest.check(OnlineSummarizerTest.normal(10000));
        System.out.printf("exp\n", new Object[0]);
        OnlineSummarizerTest.check(OnlineSummarizerTest.exp(10000));
        System.out.printf("gamma\n", new Object[0]);
        OnlineSummarizerTest.check(OnlineSummarizerTest.gamma(10000, 0.1));
    }

    private static void check(double[] samples) {
        OnlineSummarizer s = new OnlineSummarizer();
        double mean = 0.0;
        double sd = 0.0;
        int n = 1;
        for (double x : samples) {
            s.add(x);
            double old = mean;
            mean += (x - mean) / (double)n;
            sd += (x - old) * (x - mean);
            ++n;
        }
        sd = Math.sqrt(sd / (double)samples.length);
        Arrays.sort(samples);
        for (int i = 0; i < 5; ++i) {
            int index = Math.abs(Arrays.binarySearch(samples, s.getQuartile(i)));
            OnlineSummarizerTest.assertEquals((String)("quartile " + i), (double)((double)(i * (samples.length - 1)) / 4.0), (double)index, (double)10.0);
        }
        OnlineSummarizerTest.assertEquals((double)s.getQuartile(2), (double)s.getMedian(), (double)0.0);
        OnlineSummarizerTest.assertEquals((String)"mean", (double)s.getMean(), (double)mean, (double)0.0);
        OnlineSummarizerTest.assertEquals((String)"sd", (double)s.getSD(), (double)sd, (double)1.0E-8);
    }

    private static double[] normal(int n) {
        double[] r = new double[n];
        Random gen = RandomUtils.getRandom((long)1L);
        for (int i = 0; i < n; ++i) {
            r[i] = gen.nextGaussian();
        }
        return r;
    }

    private static double[] exp(int n) {
        double[] r = new double[n];
        Random gen = RandomUtils.getRandom((long)1L);
        for (int i = 0; i < n; ++i) {
            r[i] = -Math.log1p(-gen.nextDouble());
        }
        return r;
    }

    private static double[] gamma(int n, double shape) {
        double[] r = new double[n];
        RandomWrapper gen = RandomUtils.getRandom();
        Gamma gamma = new Gamma(shape, shape, (Random)gen);
        for (int i = 0; i < n; ++i) {
            r[i] = gamma.nextDouble();
        }
        return r;
    }
}

