/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.Poisson;
import org.apache.mahout.math.stats.OnlineExponentialAverage;
import org.junit.Test;

public class OnlineExponentialAverageTest
extends MahoutTestCase {
    @Test
    public void testAverage() {
        double[] t = new double[]{11.35718, 21.54637, 28.91061, 33.03586, 39.57767};
        double[] x = new double[]{1.5992071, -1.3577032, -0.3405638, 0.7048632, 0.3020558};
        double[] m = new double[]{1.5992071, -1.01681, -0.4797436, 0.2836447, 0.2966159};
        OnlineExponentialAverage averager = new OnlineExponentialAverage(5.0);
        for (int i = 0; i < t.length; ++i) {
            averager.add(t[i], x[i]);
            OnlineExponentialAverageTest.assertEquals((String)("Step " + i), (double)m[i], (double)averager.mean(), (double)1.0E-6);
        }
    }

    @Test
    public void testRate() {
        RandomWrapper gen = RandomUtils.getRandom();
        Poisson p = new Poisson(5.0, (Random)gen);
        double lastT = 0.0;
        double[] k = new double[1000];
        double[] t = new double[1000];
        for (int i = 1; i < 1000; ++i) {
            double dt = gen.nextDouble() * 10.0 + 5.0;
            t[i] = lastT + dt;
            k[i] = p.nextInt(dt * 0.2);
            lastT = t[i];
        }
        OnlineExponentialAverage averager = new OnlineExponentialAverage(2000.0);
        for (int i = 1; i < 1000; ++i) {
            averager.add(t[i], k[i]);
        }
        OnlineExponentialAverageTest.assertEquals((String)"Expected rate", (double)0.2, (double)averager.meanRate(), (double)0.01);
    }
}

