/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortFloatProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        OpenShortFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortFloatHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        OpenShortFloatHashMap map2 = (OpenShortFloatHashMap)map.clone();
        map.clear();
        OpenShortFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        OpenShortFloatHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortFloatHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        OpenShortFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenShortFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortFloatHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        map.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortFloatHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortFloatHashMapTest.assertEquals((float)22.0f, (float)((Pair)pairs.get((int)0)).v, (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortFloatHashMapTest.assertEquals((float)23.0f, (float)((Pair)pairs.get((int)1)).v, (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortFloatHashMapTest.assertEquals((float)25.0f, (float)((Pair)pairs.get((int)2)).v, (float)1.0E-6f);
        pairs.clear();
        map.forEachPair(new ShortFloatProcedure(){
            int count = 0;

            public boolean apply(short first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        OpenShortFloatHashMapTest.assertEquals((float)22.0f, (float)map.get((short)11), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((float)0.0f, (float)map.get((short)0), (float)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.adjustOrPutValue((short)11, 1.0f, 3.0f);
        OpenShortFloatHashMapTest.assertEquals((float)25.0f, (float)map.get((short)11), (float)1.0E-6f);
        map.adjustOrPutValue((short)15, 1.0f, 3.0f);
        OpenShortFloatHashMapTest.assertEquals((float)1.0f, (float)map.get((short)15), (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 22.0f);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        map.pairsMatching(new ShortFloatProcedure(){

            public boolean apply(short first, float second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortFloatHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortFloatHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortFloatHashMapTest.assertEquals((float)23.0f, (float)valueList.get(0), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((float)25.0f, (float)valueList.get(1), (float)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenShortFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortFloatHashMapTest.assertEquals((float)22.0f, (float)values.get(0), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((float)23.0f, (float)values.get(1), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((float)25.0f, (float)values.get(2), (float)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        OpenShortFloatHashMap map2 = (OpenShortFloatHashMap)map.copy();
        map.clear();
        OpenShortFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        OpenShortFloatHashMap map2 = (OpenShortFloatHashMap)map.copy();
        OpenShortFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 22.0f);
        map.put((short)12, 23.0f);
        map.put((short)13, 24.0f);
        map.put((short)14, 25.0f);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortFloatHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortFloatHashMap map = new OpenShortFloatHashMap();
        map.put((short)11, 100.0f);
        map.put((short)12, 70.0f);
        map.put((short)13, 30.0f);
        map.put((short)14, 3.0f);
        ShortArrayList keys = new ShortArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(0), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(1), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(2), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(3), (float)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortFloatHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(3), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(2), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(1), (float)1.0E-6f);
        OpenShortFloatHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(0), (float)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        float v;

        Pair(short k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

