/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.DoubleObjectProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenDoubleObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenDoubleObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101.0);
        this.anotherItem = new TestClass(99.0);
        this.anotherItem2 = new TestClass(2.0);
        this.anotherItem3 = new TestClass(3.0);
        this.anotherItem4 = new TestClass(4.0);
        this.anotherItem5 = new TestClass(5.0);
    }

    @Test
    public void testConstructors() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        for (int i = 0; i < 100; ++i) {
            map.put((double)i, (Object)this.item);
            OpenDoubleObjectHashMapTest.assertEquals((long)1L, (long)map.size());
            map.clear();
            OpenDoubleObjectHashMapTest.assertEquals((long)0L, (long)map.size());
            OpenDoubleObjectHashMapTest.assertFalse((String)("Contains: " + i), (boolean)map.containsKey((double)i));
            OpenDoubleObjectHashMapTest.assertSame(null, (Object)map.get((double)i));
        }
    }

    @Test
    public void testClone() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        OpenDoubleObjectHashMap map2 = map.clone();
        map.clear();
        OpenDoubleObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        OpenDoubleObjectHashMapTest.assertTrue((boolean)map.containsKey(11.0));
        OpenDoubleObjectHashMapTest.assertFalse((boolean)map.containsKey(12.0));
    }

    @Test
    public void testContainValue() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        OpenDoubleObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenDoubleObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem);
        map.put(12.0, (Object)this.anotherItem2);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem4);
        map.removeKey(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleObjectHashMapTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem);
        map.put(12.0, (Object)this.anotherItem2);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem4);
        map.removeKey(13.0);
        map.forEachPair((DoubleObjectProcedure)new DoubleObjectProcedure<TestClass>(){

            public boolean apply(double first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenDoubleObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenDoubleObjectHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenDoubleObjectHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenDoubleObjectHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((DoubleObjectProcedure)new DoubleObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(double first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenDoubleObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        map.put(12.0, (Object)this.anotherItem);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.item, (Object)map.get(11.0));
        OpenDoubleObjectHashMapTest.assertSame(null, (Object)map.get(0.0));
    }

    @Test
    public void testKeys() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        map.put(12.0, (Object)this.item);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        DoubleArrayList keyList = new DoubleArrayList();
        ArrayList valueList = new ArrayList();
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem2);
        map.put(12.0, (Object)this.anotherItem3);
        map.put(13.0, (Object)this.anotherItem4);
        map.put(14.0, (Object)this.anotherItem5);
        map.removeKey(13.0);
        map.pairsMatching((DoubleObjectProcedure)new DoubleObjectProcedure<TestClass>(){

            public boolean apply(double first, TestClass second) {
                return first % 2.0 == 0.0;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenDoubleObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenDoubleObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenDoubleObjectHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem);
        map.put(12.0, (Object)this.anotherItem2);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem4);
        map.removeKey(13.0);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenDoubleObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.item);
        OpenDoubleObjectHashMap map2 = (OpenDoubleObjectHashMap)map.copy();
        map.clear();
        OpenDoubleObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem);
        map.put(12.0, (Object)this.anotherItem2);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem4);
        map.removeKey(13.0);
        OpenDoubleObjectHashMap map2 = (OpenDoubleObjectHashMap)map.copy();
        OpenDoubleObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenDoubleObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0);
        OpenDoubleObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem5);
        map.put(12.0, (Object)this.anotherItem4);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem2);
        map.removeKey(13.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keysSortedByValue(keys);
        double[] keysArray = keys.toArray(new double[keys.size()]);
        OpenDoubleObjectHashMapTest.assertArrayEquals((double[])new double[]{14.0, 12.0, 11.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem5);
        map.put(12.0, (Object)this.anotherItem4);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem2);
        DoubleArrayList keys = new DoubleArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenDoubleObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenDoubleObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenDoubleObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenDoubleObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenDoubleObjectHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenDoubleObjectHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenDoubleObjectHashMap map = new OpenDoubleObjectHashMap();
        map.put(11.0, (Object)this.anotherItem5);
        map.put(12.0, (Object)this.anotherItem4);
        map.put(13.0, (Object)this.anotherItem3);
        map.put(14.0, (Object)this.anotherItem2);
        DoubleArrayList keys = new DoubleArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenDoubleObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenDoubleObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenDoubleObjectHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenDoubleObjectHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        double k;
        TestClass v;

        Pair(double k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        double x;

        TestClass(double x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Double.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return Double.compare(this.x, o.x);
        }
    }
}

