/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.function.CharShortProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenCharShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        OpenCharShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenCharShortHashMapTest.assertEquals((double)0.0, (double)map.get('\u000b'), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        OpenCharShortHashMap map2 = (OpenCharShortHashMap)map.clone();
        map.clear();
        OpenCharShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        OpenCharShortHashMapTest.assertTrue((boolean)map.containsKey('\u000b'));
        OpenCharShortHashMapTest.assertFalse((boolean)map.containsKey('\f'));
    }

    @Test
    public void testContainValue() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        OpenCharShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenCharShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharShortHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        map.forEachPair(new CharShortProcedure(){

            public boolean apply(char first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenCharShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenCharShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenCharShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenCharShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenCharShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenCharShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenCharShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new CharShortProcedure(){
            int count = 0;

            public boolean apply(char first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenCharShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        OpenCharShortHashMapTest.assertEquals((long)22L, (long)map.get('\u000b'));
        OpenCharShortHashMapTest.assertEquals((long)0L, (long)map.get('\u0000'));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.adjustOrPutValue('\u000b', (short)1, (short)3);
        OpenCharShortHashMapTest.assertEquals((long)25L, (long)map.get('\u000b'));
        map.adjustOrPutValue('\u000f', (short)1, (short)3);
        OpenCharShortHashMapTest.assertEquals((long)1L, (long)map.get('\u000f'));
    }

    @Test
    public void testKeys() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)22);
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        CharArrayList keyList = new CharArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        map.pairsMatching(new CharShortProcedure(){

            public boolean apply(char first, short second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenCharShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenCharShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenCharShortHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenCharShortHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenCharShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenCharShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenCharShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenCharShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenCharShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenCharShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        OpenCharShortHashMap map2 = (OpenCharShortHashMap)map.copy();
        map.clear();
        OpenCharShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        OpenCharShortHashMap map2 = (OpenCharShortHashMap)map.copy();
        OpenCharShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenCharShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey('\u000b');
        OpenCharShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)22);
        map.put('\f', (short)23);
        map.put('\r', (short)24);
        map.put('\u000e', (short)25);
        map.removeKey('\r');
        CharArrayList keys = new CharArrayList();
        map.keysSortedByValue(keys);
        char[] keysArray = keys.toArray(new char[keys.size()]);
        OpenCharShortHashMapTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenCharShortHashMap map = new OpenCharShortHashMap();
        map.put('\u000b', (short)100);
        map.put('\f', (short)70);
        map.put('\r', (short)30);
        map.put('\u000e', (short)3);
        CharArrayList keys = new CharArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenCharShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenCharShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenCharShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenCharShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenCharShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenCharShortHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenCharShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenCharShortHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenCharShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenCharShortHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenCharShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenCharShortHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenCharShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenCharShortHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenCharShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenCharShortHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenCharShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        char k;
        short v;

        Pair(char k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

