/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.AbstractShortList;
import org.apache.mahout.math.list.ShortArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShortArrayListTest
extends Assert {
    private ShortArrayList emptyList;
    private ShortArrayList listOfFive;

    @Before
    public void before() {
        this.emptyList = new ShortArrayList();
        this.listOfFive = new ShortArrayList();
        for (int x = 0; x < 5; ++x) {
            this.listOfFive.add((short)x);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEmpty() {
        this.emptyList.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setEmpty() {
        this.emptyList.set(1, (short)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void beforeInsertInvalidRange() {
        this.emptyList.beforeInsert(1, (short)0);
    }

    @Test
    public void testAdd() {
        int x;
        this.emptyList.add((short)12);
        ShortArrayListTest.assertEquals((long)1L, (long)this.emptyList.size());
        for (x = 0; x < 1000; ++x) {
            this.emptyList.add((short)(x % Short.MAX_VALUE));
        }
        ShortArrayListTest.assertEquals((long)1001L, (long)this.emptyList.size());
        ShortArrayListTest.assertEquals((long)12L, (long)this.emptyList.get(0));
        for (x = 0; x < 1000; ++x) {
            ShortArrayListTest.assertEquals((long)((short)(x % Short.MAX_VALUE)), (long)this.emptyList.get(x + 1));
        }
    }

    @Test
    public void testBinarySearch() {
        int x = this.listOfFive.binarySearchFromTo((short)0, 2, 4);
        ShortArrayListTest.assertEquals((long)-3L, (long)x);
        x = this.listOfFive.binarySearchFromTo((short)1, 0, 4);
        ShortArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testClone() {
        ShortArrayList l2 = this.listOfFive.copy();
        ShortArrayListTest.assertNotSame((Object)this.listOfFive, (Object)l2);
        ShortArrayListTest.assertEquals((Object)this.listOfFive, (Object)l2);
    }

    @Test
    public void testElements() {
        short[] l = new short[]{12, 24, 36, 48};
        ShortArrayList lar = new ShortArrayList(l);
        ShortArrayListTest.assertEquals((long)4L, (long)lar.size());
        ShortArrayListTest.assertSame((Object)l, (Object)lar.elements());
        short[] l2 = new short[]{3, 6, 9, 12};
        lar.elements(l2);
        ShortArrayListTest.assertSame((Object)l2, (Object)lar.elements());
    }

    @Test
    public void testEquals() {
        short[] l = new short[]{12, 24, 36, 48};
        ShortArrayList lar = new ShortArrayList(l);
        ShortArrayList lar2 = new ShortArrayList();
        for (int x = 0; x < lar.size(); ++x) {
            lar2.add(lar.get(x));
        }
        ShortArrayListTest.assertEquals((Object)lar, (Object)lar2);
        ShortArrayListTest.assertFalse((boolean)lar.equals((Object)this));
        lar2.add((short)55);
        ShortArrayListTest.assertFalse((boolean)lar.equals((Object)lar2));
    }

    @Test
    public void testForEach() {
        this.listOfFive.forEach(new ShortProcedure(){
            int count;

            public boolean apply(short element) {
                Assert.assertFalse((this.count > 2 ? 1 : 0) != 0);
                ++this.count;
                return element != 1;
            }
        });
    }

    @Test
    public void testGetQuick() {
        ShortArrayList lar = new ShortArrayList(10);
        lar.getQuick(1);
    }

    @Test
    public void testIndexOfFromTo() {
        int x = this.listOfFive.indexOfFromTo((short)0, 2, 4);
        ShortArrayListTest.assertEquals((long)-1L, (long)x);
        x = this.listOfFive.indexOfFromTo((short)1, 0, 4);
        ShortArrayListTest.assertEquals((long)1L, (long)x);
    }

    @Test
    public void testLastIndexOfFromTo() {
        ShortArrayList lar = new ShortArrayList(10);
        lar.add((short)1);
        lar.add((short)2);
        lar.add((short)3);
        lar.add((short)2);
        lar.add((short)1);
        ShortArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOf((short)2));
        ShortArrayListTest.assertEquals((long)3L, (long)lar.lastIndexOfFromTo((short)2, 2, 4));
        ShortArrayListTest.assertEquals((long)-1L, (long)lar.lastIndexOf((short)111));
    }

    @Test
    public void testPartFromTo() {
        AbstractShortList al = this.listOfFive.partFromTo(1, 2);
        ShortArrayListTest.assertEquals((long)2L, (long)al.size());
        ShortArrayListTest.assertEquals((long)1L, (long)al.get(0));
        ShortArrayListTest.assertEquals((long)2L, (long)al.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPartFromToOOB() {
        this.listOfFive.partFromTo(10, 11);
    }

    @Test
    public void testRemoveAll() {
        int x;
        ShortArrayList lar = new ShortArrayList(1000);
        for (int x2 = 0; x2 < 128; ++x2) {
            lar.add((short)x2);
        }
        ShortArrayList larOdd = new ShortArrayList(500);
        for (x = 1; x < 128; x += 2) {
            larOdd.add((short)x);
        }
        lar.removeAll((AbstractShortList)larOdd);
        ShortArrayListTest.assertEquals((long)64L, (long)lar.size());
        for (x = 0; x < lar.size(); ++x) {
            ShortArrayListTest.assertEquals((long)(x * 2), (long)lar.get(x));
        }
    }

    @Test
    public void testReplaceFromToWith() {
        this.listOfFive.add((short)5);
        ShortArrayList lar = new ShortArrayList();
        lar.add((short)44);
        lar.add((short)55);
        this.listOfFive.replaceFromToWithFromTo(2, 3, (AbstractShortList)lar, 0, 1);
        ShortArrayListTest.assertEquals((long)0L, (long)this.listOfFive.get(0));
        ShortArrayListTest.assertEquals((long)1L, (long)this.listOfFive.get(1));
        ShortArrayListTest.assertEquals((long)44L, (long)this.listOfFive.get(2));
        ShortArrayListTest.assertEquals((long)55L, (long)this.listOfFive.get(3));
        ShortArrayListTest.assertEquals((long)4L, (long)this.listOfFive.get(4));
        ShortArrayListTest.assertEquals((long)5L, (long)this.listOfFive.get(5));
    }

    @Test
    public void testRetainAllSmall() {
        ShortArrayList lar = new ShortArrayList();
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        lar.addAllOf(this.listOfFive);
        ShortArrayList lar2 = new ShortArrayList();
        lar2.add((short)3);
        lar2.add((short)4);
        ShortArrayListTest.assertTrue((boolean)lar.retainAll((AbstractShortList)lar2));
        for (int x = 0; x < lar.size(); ++x) {
            short l = lar.get(x);
            ShortArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
        ShortArrayListTest.assertEquals((long)6L, (long)lar.size());
    }

    @Test
    public void testRetainAllSmaller() {
        int x;
        ShortArrayList lar = new ShortArrayList();
        lar.addAllOf(this.listOfFive);
        ShortArrayList lar2 = new ShortArrayList();
        for (x = 0; x < 1000; ++x) {
            lar2.add((short)3);
            lar2.add((short)4);
        }
        ShortArrayListTest.assertTrue((boolean)lar.retainAll((AbstractShortList)lar2));
        for (x = 0; x < lar.size(); ++x) {
            short l = lar.get(x);
            ShortArrayListTest.assertTrue((l == 3 || l == 4 ? 1 : 0) != 0);
        }
    }
}

