/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.PermutedVectorView;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.junit.Test;

public class PermutedVectorViewTest
extends MahoutTestCase {
    @Test
    public void testViewBasics() {
        int i;
        Vector v = PermutedVectorViewTest.randomVector();
        int[] pivot = PermutedVectorViewTest.pivot();
        PermutedVectorView pvv = new PermutedVectorView(v, pivot);
        for (i = 0; i < 20; ++i) {
            PermutedVectorViewTest.assertEquals((String)("Element " + i), (double)v.get(pivot[i]), (double)pvv.get(i), (double)0.0);
        }
        pvv.set(6, 321.0);
        v.set(9, 512.0);
        for (i = 0; i < 20; ++i) {
            PermutedVectorViewTest.assertEquals((String)("Element " + i), (double)v.get(pivot[i]), (double)pvv.get(i), (double)0.0);
        }
    }

    @Test
    public void testIterators() {
        int[] pivot = PermutedVectorViewTest.pivot();
        int[] unpivot = PermutedVectorViewTest.unpivot();
        Vector v = PermutedVectorViewTest.randomVector();
        PermutedVectorView pvv = new PermutedVectorView(v, pivot);
        PermutedVectorViewTest.assertEquals((double)v.zSum(), (double)pvv.zSum(), (double)0.0);
        PermutedVectorViewTest.assertEquals((long)v.getNumNondefaultElements(), (long)pvv.getNumNondefaultElements());
        v.set(11, 0.0);
        PermutedVectorViewTest.assertEquals((long)v.getNumNondefaultElements(), (long)pvv.getNumNondefaultElements());
        Iterator vi = pvv.iterator();
        int i = 0;
        while (vi.hasNext()) {
            Vector.Element e = (Vector.Element)vi.next();
            PermutedVectorViewTest.assertEquals((String)("Index " + i), (long)i, (long)pivot[e.index()]);
            PermutedVectorViewTest.assertEquals((String)("Reverse Index " + i), (long)unpivot[i], (long)e.index());
            PermutedVectorViewTest.assertEquals((String)("Self-value " + i), (double)e.get(), (double)pvv.get(e.index()), (double)0.0);
            PermutedVectorViewTest.assertEquals((String)("Value " + i), (double)v.get(i), (double)e.get(), (double)0.0);
            ++i;
        }
    }

    private static int[] pivot() {
        return new int[]{11, 7, 10, 9, 8, 3, 17, 0, 19, 13, 12, 1, 5, 6, 16, 2, 4, 14, 18, 15};
    }

    private static int[] unpivot() {
        int[] pivot = PermutedVectorViewTest.pivot();
        int[] unpivot = new int[20];
        for (int i = 0; i < 20; ++i) {
            unpivot[pivot[i]] = i;
        }
        return unpivot;
    }

    private static Vector randomVector() {
        DenseVector v = new DenseVector(20);
        v.assign(new DoubleFunction(){
            private final Random gen = RandomUtils.getRandom();

            public double apply(double arg1) {
                return this.gen.nextDouble();
            }
        });
        return v;
    }
}

