/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.junit.Test;

public class MatrixVectorViewTest
extends MahoutTestCase {
    @Test
    public void testColumnView() {
        DenseMatrix matrix = new DenseMatrix(5, 3);
        Vector column2 = matrix.viewColumn(2);
        Matrix outerProduct = column2.cross(column2);
        MatrixVectorViewTest.assertEquals((long)matrix.numRows(), (long)outerProduct.numRows());
        MatrixVectorViewTest.assertEquals((long)matrix.numRows(), (long)outerProduct.numCols());
    }

    @Test
    public void testIndexRange() {
        Matrix m = new DenseMatrix(20, 30).assign(Functions.random());
        try {
            m.viewColumn(30);
            MatrixVectorViewTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            MatrixVectorViewTest.assertTrue((boolean)e.getMessage().startsWith("Index 30 is outside allowable"));
        }
        try {
            m.viewRow(20);
            MatrixVectorViewTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            MatrixVectorViewTest.assertTrue((boolean)e.getMessage().startsWith("Index 20 is outside allowable"));
        }
    }
}

